"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _awsSdk = _interopRequireDefault(require("aws-sdk"));
var _config = _interopRequireDefault(require("../config"));
var _config$s = _config["default"].s3,
  logBucket = _config$s.logBucket,
  accessKey = _config$s.accessKey,
  secretAccessKey = _config$s.secretAccessKey;
var s3 = new _awsSdk["default"].S3({
  accessKeyId: accessKey,
  secretAccessKey: secretAccessKey
});
var _default = {
  upload_on_s3: function () {
    var _upload_on_s = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(filename, reportedMailId) {
      var location, filePath, blob, uploadedImage;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            location = _config["default"].app.type;
            if (location == 'staging') location = 'Staging-Mails';else if (location == 'inhouse') location = 'ReportedMail-Test';else location = 'Mails';
            filePath = _path["default"].join(appRoot, 'Content', 'MailAttachments', filename);
            if (!_fs["default"].existsSync(filePath)) {
              _context.next = 12;
              break;
            }
            blob = _fs["default"].readFileSync(filePath);
            _context.next = 8;
            return s3.upload({
              Bucket: logBucket,
              Key: "".concat(location, "/").concat(reportedMailId, "/attachments/").concat(filename),
              Body: blob
            }).promise();
          case 8:
            uploadedImage = _context.sent;
            console.log('file uploaded', filename);
            _context.next = 13;
            break;
          case 12:
            console.log('file not exists', filename);
          case 13:
            _context.next = 19;
            break;
          case 15:
            _context.prev = 15;
            _context.t0 = _context["catch"](0);
            console.log(_context.t0);
            console.log('upload file failed');
          case 19:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[0, 15]]);
    }));
    function upload_on_s3(_x, _x2) {
      return _upload_on_s.apply(this, arguments);
    }
    return upload_on_s3;
  }(),
  uploadReportedMail: function () {
    var _uploadReportedMail = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(reportedEmail) {
      var _id, header, body, parsedHeader, location, upload;
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _id = reportedEmail._id, header = reportedEmail.header, body = reportedEmail.body, parsedHeader = reportedEmail.parsedHeader;
            if (_config["default"].s3.isSASS) {
              _context2.next = 15;
              break;
            }
            _context2.prev = 2;
            _context2.next = 5;
            return db.ReportedMail.updateOne({
              _id: _id
            }, {
              header: header,
              body: body,
              parsedHeader: parsedHeader
            });
          case 5:
            console.log('-----------------------Successfully saved reported mail to db!--------------------', _id);
            return _context2.abrupt("return", true);
          case 9:
            _context2.prev = 9;
            _context2.t0 = _context2["catch"](2);
            console.log(_context2.t0);
            console.log('Error saving reported mail to db!');
          case 13:
            _context2.next = 28;
            break;
          case 15:
            _context2.prev = 15;
            location = _config["default"].app.type;
            if (location == 'staging') location = 'Staging-Mails';else if (location == 'inhouse') location = 'ReportedMail-Test';else location = 'Mails';
            _context2.next = 20;
            return s3.upload({
              Bucket: logBucket,
              Key: "".concat(location, "/").concat(_id, "/mail"),
              Body: JSON.stringify(reportedEmail)
            }).promise();
          case 20:
            upload = _context2.sent;
            console.log('-----------------------Successfully saved reported mail to s3!--------------------', _id);
            _context2.next = 28;
            break;
          case 24:
            _context2.prev = 24;
            _context2.t1 = _context2["catch"](15);
            console.log(_context2.t1);
            console.log('Error saving reported mail to s3!');
          case 28:
          case "end":
            return _context2.stop();
        }
      }, _callee2, null, [[2, 9], [15, 24]]);
    }));
    function uploadReportedMail(_x3) {
      return _uploadReportedMail.apply(this, arguments);
    }
    return uploadReportedMail;
  }(),
  fetchReportedMail: function () {
    var _fetchReportedMail = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(reportedMailId) {
      var reportedMail, location, res, mail;
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return db.ReportedMail.findOne({
              _id: reportedMailId,
              deletedAt: null
            });
          case 2:
            reportedMail = _context3.sent;
            if (!(reportedMail && reportedMail.isLiteEnvReport)) {
              _context3.next = 5;
              break;
            }
            return _context3.abrupt("return", reportedMail);
          case 5:
            if (_config["default"].s3.isSASS) {
              _context3.next = 17;
              break;
            }
            _context3.prev = 6;
            console.log("------------------------------Successfully fetched mail from db!-------------------------------", reportedMailId);
            return _context3.abrupt("return", reportedMail);
          case 11:
            _context3.prev = 11;
            _context3.t0 = _context3["catch"](6);
            console.log(_context3.t0);
            console.log('Error fetching reported mail from db');
          case 15:
            _context3.next = 35;
            break;
          case 17:
            _context3.prev = 17;
            location = _config["default"].app.type;
            if (location == 'staging') location = 'Staging-Mails';else if (location == 'inhouse') location = 'ReportedMail-Test';else location = 'Mails';
            _context3.next = 22;
            return s3.getObject({
              Bucket: logBucket,
              Key: "".concat(location, "/").concat(reportedMailId, "/mail")
            }).promise();
          case 22:
            res = _context3.sent;
            mail = JSON.parse(res.Body);
            reportedMail['parsedHeader'] = mail.parsedHeader;
            reportedMail['header'] = mail.header;
            reportedMail['body'] = mail.body;
            console.log("------------------------------Successfully fetched mail from s3!-------------------------------", reportedMailId);
            return _context3.abrupt("return", reportedMail);
          case 31:
            _context3.prev = 31;
            _context3.t1 = _context3["catch"](17);
            console.log(_context3.t1);
            console.log('Error Fetching Reported Mail from s3!');
          case 35:
          case "end":
            return _context3.stop();
        }
      }, _callee3, null, [[6, 11], [17, 31]]);
    }));
    function fetchReportedMail(_x4) {
      return _fetchReportedMail.apply(this, arguments);
    }
    return fetchReportedMail;
  }(),
  uploadReportedMailAttachments: function () {
    var _uploadReportedMailAttachments = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(reportedMailId, filePath, fileName, ContentBytes, ContentType) {
      var writeStream, location, upload;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            if (_config["default"].s3.isSASS) {
              _context4.next = 14;
              break;
            }
            _context4.prev = 1;
            writeStream = _fs["default"].createWriteStream(filePath);
            writeStream.write(Buffer.from(ContentBytes, "base64"));
            console.log("------------------------------Successfully saved mail attachment to db!-------------------------------", reportedMailId);
            return _context4.abrupt("return", true);
          case 8:
            _context4.prev = 8;
            _context4.t0 = _context4["catch"](1);
            console.log(_context4.t0);
            console.log('Error saving Reported Mail Attachment to db');
          case 12:
            _context4.next = 28;
            break;
          case 14:
            _context4.prev = 14;
            location = _config["default"].app.type;
            if (location == 'staging') location = 'Staging-Mails';else if (location == 'inhouse') location = 'ReportedMail-Test';else location = 'Mails';
            _context4.next = 19;
            return s3.upload({
              Bucket: logBucket,
              Key: "".concat(location, "/").concat(reportedMailId, "/attachments/").concat(fileName),
              Body: Buffer.from(ContentBytes, "base64"),
              ContentType: ContentType
            }).promise();
          case 19:
            upload = _context4.sent;
            console.log("------------------------------Successfully saved mail attachment to s3!-------------------------------", reportedMailId);
            return _context4.abrupt("return", fileName);
          case 24:
            _context4.prev = 24;
            _context4.t1 = _context4["catch"](14);
            console.log(_context4.t1);
            console.log('Error saving Reported Mail Attachment to s3');
          case 28:
          case "end":
            return _context4.stop();
        }
      }, _callee4, null, [[1, 8], [14, 24]]);
    }));
    function uploadReportedMailAttachments(_x5, _x6, _x7, _x8, _x9) {
      return _uploadReportedMailAttachments.apply(this, arguments);
    }
    return uploadReportedMailAttachments;
  }(),
  fetchReportedMailAttachments: function () {
    var _fetchReportedMailAttachments = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(reportedMailId, fileName) {
      var filePath, file, location, attachment;
      return _regenerator["default"].wrap(function _callee5$(_context5) {
        while (1) switch (_context5.prev = _context5.next) {
          case 0:
            if (_config["default"].s3.isSASS) {
              _context5.next = 17;
              break;
            }
            _context5.prev = 1;
            filePath = _path["default"].join(appRoot, 'Content', 'MailAttachments', fileName);
            if (_fs["default"].existsSync(filePath)) {
              _context5.next = 5;
              break;
            }
            throw new RequestError('File does not exist');
          case 5:
            file = _fs["default"].createReadStream(filePath);
            console.log("------------------------------Successfully fetched mail attachment from db!-------------------------------", reportedMailId);
            return _context5.abrupt("return", file);
          case 10:
            _context5.prev = 10;
            _context5.t0 = _context5["catch"](1);
            console.log(_context5.t0);
            console.log('Error Feteching Reported Mail Attachment from db!');
            return _context5.abrupt("return", null);
          case 15:
            _context5.next = 31;
            break;
          case 17:
            _context5.prev = 17;
            location = _config["default"].app.type;
            if (location == 'staging') location = 'Staging-Mails';else if (location == 'inhouse') location = 'ReportedMail-Test';else location = 'Mails';
            _context5.next = 22;
            return s3.getObject({
              Bucket: logBucket,
              Key: "".concat(location, "/").concat(reportedMailId, "/attachments/").concat(fileName)
            }).promise();
          case 22:
            attachment = _context5.sent;
            console.log("------------------------------Successfully fetched mail attachment from s3!-------------------------------", reportedMailId);
            return _context5.abrupt("return", attachment.Body);
          case 27:
            _context5.prev = 27;
            _context5.t1 = _context5["catch"](17);
            console.log('Error Feteching Reported Mail Attachment from s3!');
            console.log(_context5.t1);
          case 31:
          case "end":
            return _context5.stop();
        }
      }, _callee5, null, [[1, 10], [17, 27]]);
    }));
    function fetchReportedMailAttachments(_x10, _x11) {
      return _fetchReportedMailAttachments.apply(this, arguments);
    }
    return fetchReportedMailAttachments;
  }(),
  uploadSiemLogs: function () {
    var _uploadSiemLogs = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(reportedEmail, companyId) {
      var to, from, subject, mailRecievedTime, spf, dkim, dmarc, senderIp, internetMessageId, location, upload;
      return _regenerator["default"].wrap(function _callee6$(_context6) {
        while (1) switch (_context6.prev = _context6.next) {
          case 0:
            _context6.prev = 0;
            if (!(_config["default"].app.type == "production")) {
              _context6.next = 8;
              break;
            }
            to = reportedEmail.to, from = reportedEmail.from, subject = reportedEmail.subject, mailRecievedTime = reportedEmail.mailRecievedTime, spf = reportedEmail.spf, dkim = reportedEmail.dkim, dmarc = reportedEmail.dmarc, senderIp = reportedEmail.senderIp, internetMessageId = reportedEmail.internetMessageId;
            location = 'SIEM-Logs';
            _context6.next = 6;
            return s3.upload({
              Bucket: logBucket,
              Key: "".concat(location, "/").concat(companyId, "/").concat(internetMessageId, ".log"),
              Body: JSON.stringify(reportedEmail)
            }).promise();
          case 6:
            upload = _context6.sent;
            console.log('\x1b[32m%s\x1b[0m', '-----------------------Successfully looged reported mail to s3!--------------------', companyId);
          case 8:
            _context6.next = 14;
            break;
          case 10:
            _context6.prev = 10;
            _context6.t0 = _context6["catch"](0);
            console.log(_context6.t0);
            console.log('Error saving reported mail to s3!');
          case 14:
          case "end":
            return _context6.stop();
        }
      }, _callee6, null, [[0, 10]]);
    }));
    function uploadSiemLogs(_x12, _x13) {
      return _uploadSiemLogs.apply(this, arguments);
    }
    return uploadSiemLogs;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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