"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _authenticator = _interopRequireDefault(require("authenticator"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  otp: _joi["default"].string().required().min(6).max(6)
});
var getQR = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var formattedKey, uri, user;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          formattedKey = _authenticator["default"].generateKey();
          uri = _authenticator["default"].generateTotpUri(formattedKey, req.user.email, "TPIR", 'SHA1', 6, 30);
          user = req.user;
          user.set({
            'security.tOtpKey': formattedKey
          });
          _context.next = 7;
          return user.save();
        case 7:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            uri: uri
          }));
        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 14:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 10]]);
  }));
  return function getQR(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var verifyQR = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var user, otp, isVerify;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          user = req.user;
          otp = req.body.otp;
          _context2.next = 5;
          return _authenticator["default"].verifyToken(user.security.tOtpKey, otp);
        case 5:
          isVerify = _context2.sent;
          if (isVerify) {
            _context2.next = 8;
            break;
          }
          throw new RequestError('Invalid otp recieved');
        case 8:
          user.set({
            'security.status': true,
            'security.otpType': 'TOTP',
            'security.otp': null,
            'security.otpExpiry': null
          });
          _context2.next = 11;
          return user.save();
        case 11:
          return _context2.abrupt("return", res.status(200).send({
            Success: true,
            message: 'Two factor enabled successfully'
          }));
        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](0);
          console.log('error', _context2.t0);
          next(_context2.t0);
        case 18:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 14]]);
  }));
  return function verifyQR(_x4, _x5, _x6) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, getQR);
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _validator.validateBody)(validator), verifyQR);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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