"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var features = [{
  name: "Custom Smtp",
  //done frontend //backend
  description: "Ability to add their custom SMTP to send notification emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-CSTM"
}, {
  name: "Email Alert to SOC Team for threat reports. Threshold configurable",
  //done frontend backend
  description: "Send alerts to the SOC team when a mail is reported with configurable soc emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-EASOC"
}, {
  name: "Report Notification",
  //done //backend //
  description: "Notify users when a mail is reported.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-RN"
}, {
  name: "Notification to user on action taken on email",
  //done backend //
  description: "Notify users about actions taken on reported emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-NACT"
}, {
  name: "Customisable Email Templates",
  //done frontend //backend
  description: "Provide customizable templates for notification emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-CET"
}, {
  name: "View Reported Email",
  //done frontend //
  description: "Ability to view reported email.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-VRE"
}, {
  name: "View Reported Email Body",
  //done frontend //
  description: "Ability to view reported email.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-VREB"
}, {
  name: "Header analysis",
  //done frontend backend
  description: "Analyze email headers for metadata and potential threats.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-HA"
}, {
  name: "SPF, DKIM, DMARC check-pass",
  //done backend
  description: "Check and validate SPF, DKIM, and DMARC records to ensure email authenticity.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-SDD"
}, {
  name: "IP Reputation Check",
  //done backend //frontend
  description: "Check the reputation of the sending IP address to detect potential spam or malicious sources.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-IPRC"
}, {
  name: "Sender Domain Reputation Check",
  //done backend //frontend
  description: "Check the reputation of the sender’s domain to identify potential phishing or spam sources.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-SDRC"
}, {
  name: "DNS blackhole list",
  //done frontend //backend
  description: "Check if the sender’s domain or IP address is on a DNS blackhole list.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-DBL"
}, {
  name: "User Awareness Score (Based on suspicious email reporting)",
  //done backend
  description: "Calculate a score based on user reports of suspicious emails to evaluate their awareness level.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-UAS"
}, {
  name: "Download raw email",
  //done frontend //
  description: "Allow users to download raw email headers for further analysis.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-DRH"
}, {
  name: "Spam Score to reported email",
  //done backend frontend
  description: "Assign a spam score to reported emails to help identify potential spam.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-SSRE"
}, {
  name: "Email content scan",
  //done 
  description: "Scan email content for potential threats such as phishing or malware.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-ECS"
}, {
  name: "Advanced Attachment and URL/Link protection",
  //done frontend backend
  description: "Protect against threats by scanning attachments and URLs/links in emails for malicious content.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-AALP"
}, {
  name: "View Attachment and URL/Links in reported email",
  //done backend
  description: "View Attachment and URL/Links in reported email with or without scanner",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-VAUIR"
}, {
  name: "Hash comparison for malware detection",
  //done
  description: "Perform hash comparison on email attachments to detect known malware signatures.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-HCMD"
}, {
  name: "Who else (Who all within the organization received the mail)",
  //done frontend //backend
  description: "Identify other users within the organization who received the same email.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-WE"
}, {
  name: "Action (Restore / Trash / Deletion) of suspicious email for entire organization",
  //done frontend //backend
  description: "Take action on suspicious emails by restoring, trashing or deleting them across the organization.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-ARTD"
}, {
  name: "Find similar emails in the inbox",
  //done frontend //backend
  description: "Allow users to see similar emails in their inbox for easy identification of potential threats with same subject.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-FSEI"
}, {
  name: "Advanced search",
  //done frontend //backend
  description: "Provide an advanced search capability to quickly find specific emails or threats.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-ADVS"
}, {
  name: "Email Broadcast",
  //done frontend //backend
  description: "Broadcast a notification email to a group or entire organization for important alerts.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-EB"
}, {
  name: "TSAT",
  //done frontend backend
  description: "Integration with TSAT for tracking and analyzing threat-related metrics.",
  category: "Integrations",
  type: "dynamic",
  featureCode: "TPIR-TSAT"
}, {
  name: "WhatsApp",
  //done frontend backend
  description: "Generate and send reports via WhatsApp for quick notifications and updates.",
  category: "Reporting",
  type: "dynamic",
  featureCode: "TPIR-WA"
}];
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var companies, insertFeatures, featureIds, companyPromises;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return db.Company.find({
            deletedAt: null
          });
        case 3:
          companies = _context2.sent;
          _context2.next = 6;
          return db.Feature.insertMany(features);
        case 6:
          insertFeatures = _context2.sent;
          featureIds = insertFeatures.map(function (feature) {
            return feature._id;
          });
          companyPromises = companies.map( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(company) {
              var companyId, companyUpdate;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    companyId = company._id;
                    _context.prev = 1;
                    companyUpdate = insertFeatures.map(function (feature) {
                      return db.CompanyFeature.create({
                        companyId: companyId,
                        featureId: feature._id,
                        featureCode: feature.featureCode
                      });
                    });
                    _context.next = 5;
                    return Promise.all([companyUpdate]);
                  case 5:
                    _context.next = 10;
                    break;
                  case 7:
                    _context.prev = 7;
                    _context.t0 = _context["catch"](1);
                    console.error("Error processing company ".concat(companyId, ":"), _context.t0);
                  case 10:
                  case "end":
                    return _context.stop();
                }
              }, _callee, null, [[1, 7]]);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }());
          _context2.next = 11;
          return Promise.all(companyPromises);
        case 11:
          res.status(200).send({
            message: 'Updates completed successfully'
          });
          _context2.next = 18;
          break;
        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](0);
          console.error('Error processing companies:', _context2.t0);
          next(_context2.t0);
        case 18:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 14]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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