"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var companies, companyPromises;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return db.Company.find({
            deletedAt: null
          });
        case 3:
          companies = _context2.sent;
          // Iterate over companies and perform operations
          companyPromises = companies.map( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(company) {
              var companyId, adminUpdate, companyUpdate, metadata, metaCreate, allUsersGroup, activeUsersGroup, userUpdate, activeUserUpdate, deleteUsersUpdate;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    companyId = company._id;
                    _context.prev = 1;
                    _context.next = 4;
                    return db.Admin.updateOne({
                      companyId: companyId,
                      deletedAt: null
                    }, {
                      $set: {
                        tacIdentityKey: null
                      }
                    });
                  case 4:
                    adminUpdate = _context.sent;
                    _context.next = 7;
                    return db.Company.updateOne({
                      _id: companyId
                    }, {
                      $set: {
                        isTacEnabled: false,
                        tacCompanyId: null,
                        tacLicenseKey: null,
                        isNewCompany: false,
                        packageAccessKey: null,
                        lastModifiedPackageId: null,
                        packageModifiedLocally: false
                      }
                    });
                  case 7:
                    companyUpdate = _context.sent;
                    // Create default metadata in bulk
                    metadata = [{
                      name: 'userLimitMessenger',
                      value: '0',
                      companyId: companyId
                    }];
                    _context.next = 11;
                    return db.MetaData.insertMany(metadata);
                  case 11:
                    metaCreate = _context.sent;
                    _context.next = 14;
                    return db.Group.create({
                      groupName: 'all-users-tpir',
                      type: 'Admin',
                      companyId: companyId,
                      tacIdentityKey: null,
                      groupId: null,
                      tacGroupId: null,
                      emailAccess: false,
                      messengerAccess: false,
                      isDefaultGroup: true,
                      deletedAt: null
                    });
                  case 14:
                    allUsersGroup = _context.sent;
                    _context.next = 17;
                    return db.Group.create({
                      groupName: 'Active Users',
                      type: 'Admin',
                      companyId: companyId,
                      tacIdentityKey: null,
                      groupId: null,
                      tacGroupId: null,
                      emailAccess: true,
                      messengerAccess: false,
                      isDefaultGroup: false,
                      deletedAt: null
                    });
                  case 17:
                    activeUsersGroup = _context.sent;
                    _context.next = 20;
                    return db.User.updateMany({
                      companyId: companyId,
                      deletedAt: null
                    }, {
                      $addToSet: {
                        groups: allUsersGroup._id
                      }
                    });
                  case 20:
                    userUpdate = _context.sent;
                    _context.next = 23;
                    return db.User.updateMany({
                      companyId: companyId,
                      isActive: true,
                      deletedAt: null
                    }, {
                      $addToSet: {
                        groups: activeUsersGroup._id
                      }
                    });
                  case 23:
                    activeUserUpdate = _context.sent;
                    _context.next = 26;
                    return db.User.deleteMany({
                      companyId: companyId,
                      groups: {
                        $nin: [activeUsersGroup._id]
                      },
                      deletedAt: null
                    });
                  case 26:
                    deleteUsersUpdate = _context.sent;
                    _context.next = 32;
                    break;
                  case 29:
                    _context.prev = 29;
                    _context.t0 = _context["catch"](1);
                    console.error("Error processing company ".concat(companyId, ":"), _context.t0);
                  case 32:
                  case "end":
                    return _context.stop();
                }
              }, _callee, null, [[1, 29]]);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }()); // Execute all company operations
          _context2.next = 7;
          return Promise.all(companyPromises);
        case 7:
          res.status(200).send({
            message: 'Updates completed successfully'
          });
          _context2.next = 14;
          break;
        case 10:
          _context2.prev = 10;
          _context2.t0 = _context2["catch"](0);
          console.error('Error processing companies:', _context2.t0);
          next(_context2.t0);
        case 14:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 10]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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