"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$user;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          if (!req.user.sudoPassword) {
            _auditLog["default"].create(req, 'Logout');
          }
          if ((_req$user = req.user) !== null && _req$user !== void 0 && _req$user.email) {
            logger.info("User ".concat(req.user.email, " logged out"), {
              client: req.user.companyId,
              request: req,
              event: 'Logged Out'
            });
          }
          if (!(req.user.type == 'root')) {
            _context.next = 7;
            break;
          }
          _context.next = 5;
          return db.Admin.updateOne({
            email: req.user.email
          }, {
            loggedIn: false
          });
        case 5:
          _context.next = 9;
          break;
        case 7:
          _context.next = 9;
          return db.Employee.updateOne({
            email: req.user.email
          }, {
            loggedIn: false
          });
        case 9:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "successfully Logout"
          }));
        case 10:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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