"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _permission = require("../../middlewares/permission");
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  password: _joi["default"].string().required(),
  currentpassword: _joi["default"].string().required()
});

/**
 * @api {post} /api/admin/change-password Change Password
 * @apiName change-password
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} current password    Required current password of the User.
 * @apiBody {String} password            Required new password of the User.
 * 
 *
 * @apiSuccess (201) {String} success     true
 * @apiSuccess (201) {String} Message     Password Updated Successfully!
 * 
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "Message":"Password Updated Successfully!"
 *      }
 * 
 * @apiError (404)  {String} status  false
 * @apiError (404)  {String} message Admin Not Found!
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Admin Not found!"]
 *      }
 *
 * 
 * @apiError (500)  {String} status  false
 * @apiError (500)  {String} message Current Password Does not match!
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *     {
 *      "success":false,
 *      "messages":["Current Password Does not match!"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var user, _req$body, currentpassword, password, passwordMatch, isSamePassword;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          user = req.user;
          _req$body = req.body, currentpassword = _req$body.currentpassword, password = _req$body.password;
          passwordMatch = _bcryptjs["default"].compareSync(currentpassword, user.password);
          isSamePassword = _bcryptjs["default"].compareSync(password, user.password);
          if (!isSamePassword) {
            _context.next = 7;
            break;
          }
          throw new RequestError('New password must differ from the current password.');
        case 7:
          if (passwordMatch) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Current Password Does not match!');
        case 9:
          user.set({
            password: _bcryptjs["default"].hashSync(password),
            loggedIn: false
          });
          _context.next = 12;
          return user.save();
        case 12:
          _auditLog["default"].create(req, 'Forgot Password');
          logger.info("User ".concat(user.email, " Change Password"), {
            client: user.companyId,
            request: req,
            event: 'Change Password'
          });
          return _context.abrupt("return", res.status(201).send({
            success: true,
            Message: "Password Updated Successfully!"
          }));
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", next(new RequestError(_context.t0)));
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _permission.permission)('Users', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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