"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _functions = require("../../functions");
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  companyId: _joi["default"].string().hex().length(24).required(),
  email: _joi["default"].string().email().required(),
  type: _joi["default"].any().valid('root', 'employee').required()
});

/**
 * @api {post} /api/admin/check-company Check Company
 * @apiName check-company
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} email                      Required email of the User.
 * @apiBody {String=root,employee} type=root    Required type of the User.
 * @apiBody {String} companyId                  Required companyId of the User.
 * 
 * 
 * @apiSuccess {Boolean} success   true
 * @apiSuccess {String}  message   successfully validate company
 * @apiSuccess {Boolean} isOtp     false
 * @apiSuccess {String}  otpType   Type of Otp
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *    {
 *       "success": true,
 *       "message": "successfully validate company",
 *       "isOtp": false,
 *       "otpType": null
 *      }
 * 
 * 
 * @apiError (400)  {String} status  false
 * @apiError (400)  {String} message \"companyId\" length must be 24 characters long
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *     {
 *      "success":false,
 *      "messages":["\"companyId\" length must be 24 characters long"]
 *      }
 * 
 *  @apiError (404)  {String} status false
 *  @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, type, companyId, company, user, message, isOtp, otpType, otp, otpExpiry;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, type = _req$body.type, companyId = _req$body.companyId;
          _context.next = 4;
          return db.Company.findOne({
            _id: companyId,
            deletedAt: null
          });
        case 4:
          company = _context.sent;
          user = null;
          if (!(type == 'root')) {
            _context.next = 12;
            break;
          }
          _context.next = 9;
          return db.Admin.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 9:
          user = _context.sent;
          _context.next = 15;
          break;
        case 12:
          _context.next = 14;
          return db.Employee.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 14:
          user = _context.sent;
        case 15:
          if (user) {
            _context.next = 17;
            break;
          }
          throw new RequestError('Email not found in TPIR database please register through this email and then use', 404);
        case 17:
          message = 'successfully validate company', isOtp = false, otpType = null;
          if (!(user.security && user.security.status)) {
            _context.next = 34;
            break;
          }
          isOtp = true;
          if (!(user.security.otpType == 'MAIL')) {
            _context.next = 32;
            break;
          }
          otp = (0, _functions.randomString)(6, '0123456789');
          otpExpiry = new Date();
          _context.next = 25;
          return _mailer["default"].sendOTP(user.firstName, user.email, otp, companyId);
        case 25:
          user.set({
            'security.otp': otp,
            'security.otpExpiry': otpExpiry
          });
          _context.next = 28;
          return user.save();
        case 28:
          otpType = 'MAIL';
          message = "OTP has been sent to your emailId";
          _context.next = 34;
          break;
        case 32:
          otpType = 'TOPT';
          message = "Please check OTP in your Authenticator App";
        case 34:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: message,
            isOtp: isOtp,
            otpType: otpType,
            showLoginViaTa: {
              show: company === null || company === void 0 ? void 0 : company.isTacEnabled,
              companyName: company.name,
              alias: company.alias
            }
          }));
        case 37:
          _context.prev = 37;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 41:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 37]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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