"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  email: _joi["default"].string().email().required()
});

/**
 * @api {post} /api/admin/check-email Check Mail
 * @apiName check-email
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String}    email     Required email of the User.
 * 
 * @apiSuccess {String} success   true
 * @apiSuccess {String} message   email is valid
 * @apiSuccess {String} companies list of companies
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"email is valid",
 *     "companies": [
        {
            "_id": "63ad46cf6b429daa7aa9b697",
            "name": "Kratikal tech pvt ltd"
        },
        {
            "_id": "63ad46cf6b429daa7aa9b697",
            "name": "Kratikal tech pvt ltd",
            "type": "employee"
        }
        ]
 *      }
 * 
 * @apiError (404)  {String} status false
 * @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var email, employeeCompanyIds, user, employee, companies, i, employeeCompany, _i;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          email = req.body.email;
          employeeCompanyIds = [];
          _context.next = 5;
          return db.Admin.findOne({
            email: email,
            deletedAt: null
          });
        case 5:
          user = _context.sent;
          _context.next = 8;
          return db.Employee.find({
            email: email,
            deletedAt: null
          });
        case 8:
          employee = _context.sent;
          if (!(!user && employee.length == 0)) {
            _context.next = 11;
            break;
          }
          throw new RequestError('Invalid email received!', 404);
        case 11:
          companies = [];
          if (!(user && user.companyId)) {
            _context.next = 16;
            break;
          }
          _context.next = 15;
          return db.Company.find({
            _id: user ? user.companyId : ''
          }, '_id name');
        case 15:
          companies = _context.sent;
        case 16:
          if (employee.length) {
            for (i = 0; i < employee.length; i++) {
              employeeCompanyIds.push(employee[i].companyId);
            }
          }
          _context.next = 19;
          return db.Company.find({
            _id: {
              $in: employeeCompanyIds
            }
          }, '_id name');
        case 19:
          employeeCompany = _context.sent;
          for (_i = 0; _i < employeeCompany.length; _i++) {
            companies.push({
              _id: employeeCompany[_i]._id,
              name: employeeCompany[_i].name,
              type: 'employee'
            });
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "email is valid",
            companies: companies
          }));
        case 24:
          _context.prev = 24;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 28:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 24]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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