"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _validator = require("../../middlewares/validator");
var _sanitizer = require("../../middlewares/sanitizer");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  email: _joi["default"].string().email().required(),
  companyId: _joi["default"].string().hex().length(24).required(),
  type: _joi["default"].any().valid('root', 'employee')
});

/**
 * @api {post} /api/admin/forgot-password Forgot Password
 * @apiName forgot-password
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} email                      Required email of the User.
 * @apiBody {String=root,employee} type=root    Required type of the User.
 * @apiBody {String} companyId                  Required companyId of the User.
 * 
 * 
 * @apiSuccess {String} success   true
 * @apiSuccess {String} message   password reset link has been sent to you emailId
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"password reset link has been sent to you emailId"
 *      }
 * 
 * @apiError (404)  {String} status false
 * @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, _req$body$type, type, companyId, user, token, encryptEmail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, _req$body$type = _req$body.type, type = _req$body$type === void 0 ? 'root' : _req$body$type, companyId = _req$body.companyId;
          user = null, token = (0, _functions.randomString)(20);
          if (!(type == 'root')) {
            _context.next = 9;
            break;
          }
          _context.next = 6;
          return db.Admin.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 6:
          user = _context.sent;
          _context.next = 12;
          break;
        case 9:
          _context.next = 11;
          return db.Employee.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 11:
          user = _context.sent;
        case 12:
          if (user) {
            _context.next = 14;
            break;
          }
          throw new RequestError('invalid emailId recieved');
        case 14:
          user.set({
            verfKey: token,
            verfKeyExpiry: new Date()
          });
          _context.next = 17;
          return user.save();
        case 17:
          _context.next = 19;
          return _crypto["default"].encrypt(email);
        case 19:
          encryptEmail = _context.sent;
          encryptEmail = encodeURIComponent(encryptEmail);
          _context.next = 23;
          return _mailer["default"].sendResetLink(user.firstName, email, encryptEmail, token, companyId);
        case 23:
          req['user'] = user;
          _auditLog["default"].create(req, 'Forgot Password');
          logger.info("User ".concat(email, " Forgot Password"), {
            client: user.companyId,
            request: req,
            event: 'Forgot Password'
          });
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'password reset link has been sent to you emailId'
          }));
        case 29:
          _context.prev = 29;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(new RequestError(_context.t0));
        case 33:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 29]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwiZW1haWwiLCJzdHJpbmciLCJyZXF1aXJlZCIsImNvbXBhbnlJZCIsImhleCIsImxlbmd0aCIsInR5cGUiLCJhbnkiLCJ2YWxpZCIsImNvbnRyb2xsZXIiLCJyZXEiLCJyZXMiLCJuZXh0IiwiYm9keSIsInVzZXIiLCJ0b2tlbiIsInJhbmRvbVN0cmluZyIsImRiIiwiQWRtaW4iLCJmaW5kT25lIiwiZGVsZXRlZEF0IiwiRW1wbG95ZWUiLCJSZXF1ZXN0RXJyb3IiLCJzZXQiLCJ2ZXJmS2V5IiwidmVyZktleUV4cGlyeSIsIkRhdGUiLCJzYXZlIiwiY3J5cHRvIiwiZW5jcnlwdCIsImVuY3J5cHRFbWFpbCIsImVuY29kZVVSSUNvbXBvbmVudCIsIm1haWxlciIsInNlbmRSZXNldExpbmsiLCJmaXJzdE5hbWUiLCJ1c2VyQWN0aXZpdHkiLCJjcmVhdGUiLCJsb2dnZXIiLCJpbmZvIiwiY2xpZW50IiwicmVxdWVzdCIsImV2ZW50Iiwic3RhdHVzIiwic2VuZCIsInN1Y2Nlc3MiLCJtZXNzYWdlIiwiY29uc29sZSIsImxvZyIsImFwaVJvdXRlciIsImV4cHJlc3MiLCJSb3V0ZXIiLCJyb3V0ZSIsInBvc3QiLCJodG1sc2FuaXRpemUiLCJ2YWxpZGF0ZUJvZHkiXSwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYXBpL2FkbWluL2ZvcmdvdC1wYXNzd29yZC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgSm9pIGZyb20gJ2pvaSc7XG5pbXBvcnQgZXhwcmVzcyBmcm9tICdleHByZXNzJztcblxuaW1wb3J0IGNyeXB0byBmcm9tICcuLi8uLi9jcnlwdG8nO1xuaW1wb3J0IG1haWxlciBmcm9tICcuLi8uLi9tYWlsZXInO1xuaW1wb3J0IHsgcmFuZG9tU3RyaW5nIH0gZnJvbSAnLi4vLi4vZnVuY3Rpb25zJztcbmltcG9ydCB1c2VyQWN0aXZpdHkgZnJvbSAnLi4vLi4vc2VydmljZS9hdWRpdC1sb2cnO1xuaW1wb3J0IHsgdmFsaWRhdGVCb2R5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvdmFsaWRhdG9yJztcbmltcG9ydCB7IHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVyJztcbmltcG9ydCB7IGh0bWxzYW5pdGl6ZSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3Nhbml0aXplSHRtbCc7XG5cbmxldCB2YWxpZGF0b3IgPSBKb2kub2JqZWN0KCkua2V5cyh7XG5cdGVtYWlsOiBKb2kuc3RyaW5nKCkuZW1haWwoKS5yZXF1aXJlZCgpLFxuXHRjb21wYW55SWQ6IEpvaS5zdHJpbmcoKS5oZXgoKS5sZW5ndGgoMjQpLnJlcXVpcmVkKCksXG5cdHR5cGU6IEpvaS5hbnkoKS52YWxpZCgncm9vdCcsICdlbXBsb3llZScpLFxufSk7XG5cbi8qKlxuICogQGFwaSB7cG9zdH0gL2FwaS9hZG1pbi9mb3Jnb3QtcGFzc3dvcmQgRm9yZ290IFBhc3N3b3JkXG4gKiBAYXBpTmFtZSBmb3Jnb3QtcGFzc3dvcmRcbiAqIEBhcGlHcm91cCBBdXRoZW50aWNhdGlvblxuICogXG4gKiBAYXBpVmVyc2lvbiAxLjAuMFxuICogXG4gKiBAYXBpQm9keSB7U3RyaW5nfSBlbWFpbCAgICAgICAgICAgICAgICAgICAgICBSZXF1aXJlZCBlbWFpbCBvZiB0aGUgVXNlci5cbiAqIEBhcGlCb2R5IHtTdHJpbmc9cm9vdCxlbXBsb3llZX0gdHlwZT1yb290ICAgIFJlcXVpcmVkIHR5cGUgb2YgdGhlIFVzZXIuXG4gKiBAYXBpQm9keSB7U3RyaW5nfSBjb21wYW55SWQgICAgICAgICAgICAgICAgICBSZXF1aXJlZCBjb21wYW55SWQgb2YgdGhlIFVzZXIuXG4gKiBcbiAqIFxuICogQGFwaVN1Y2Nlc3Mge1N0cmluZ30gc3VjY2VzcyAgIHRydWVcbiAqIEBhcGlTdWNjZXNzIHtTdHJpbmd9IG1lc3NhZ2UgICBwYXNzd29yZCByZXNldCBsaW5rIGhhcyBiZWVuIHNlbnQgdG8geW91IGVtYWlsSWRcbiAqIFxuICogQGFwaVN1Y2Nlc3NFeGFtcGxlIFN1Y2Nlc3MtUmVzcG9uc2U6XG4gKiAgICAgSFRUUC8xLjEgMjAwIE9LXG4gKiAgICAge1xuICogICAgICBcInN1Y2Nlc3NcIjp0cnVlLFxuICogICAgICBcIm1lc3NhZ2VcIjpcInBhc3N3b3JkIHJlc2V0IGxpbmsgaGFzIGJlZW4gc2VudCB0byB5b3UgZW1haWxJZFwiXG4gKiAgICAgIH1cbiAqIFxuICogQGFwaUVycm9yICg0MDQpICB7U3RyaW5nfSBzdGF0dXMgZmFsc2VcbiAqIEBhcGlFcnJvciAoNDA0KSAge1N0cmluZ30gbWVzc2FnZSBFbWFpbCBub3QgZm91bmQgaW4gVFBJUiBkYXRhYmFzZSBwbGVhc2UgcmVnaXN0ZXIgdGhyb3VnaCB0aGlzIGVtYWlsIGFuZCB0aGVuIHVzZS5cbiAqIFxuICogQGFwaUVycm9yRXhhbXBsZSBFcnJvci1SZXNwb25zZTpcbiAqICAgICBIVFRQLzEuMSA0MDQgTm90IEZvdW5kXG4gKiAgICAge1xuICogICAgICBcInN1Y2Nlc3NcIjpmYWxzZSxcbiAqICAgICAgXCJtZXNzYWdlc1wiOltcIkVtYWlsIG5vdCBmb3VuZCBpbiBUUElSIGRhdGFiYXNlIHBsZWFzZSByZWdpc3RlciB0aHJvdWdoIHRoaXMgZW1haWwgYW5kIHRoZW4gdXNlXCJdXG4gKiAgICAgIH1cbiAqL1xuXG5cblxubGV0IGNvbnRyb2xsZXIgPSBhc3luYyAocmVxLCByZXMsIG5leHQpID0+IHtcbiAgICB0cnkge1xuICAgICAgICBjb25zdCB7IGVtYWlsLCB0eXBlID0gJ3Jvb3QnLCBjb21wYW55SWQgfSA9IHJlcS5ib2R5O1xuICAgICAgICBsZXQgdXNlciA9IG51bGwsIHRva2VuID0gcmFuZG9tU3RyaW5nKDIwKTtcbiAgICAgICAgaWYodHlwZSA9PSAncm9vdCcpe1xuICAgICAgICAgICAgdXNlciA9IGF3YWl0IGRiLkFkbWluLmZpbmRPbmUoeyBcbiAgICAgICAgICAgICAgICBlbWFpbCwgXG4gICAgICAgICAgICAgICAgY29tcGFueUlkLFxuICAgICAgICAgICAgICAgIGRlbGV0ZWRBdDogbnVsbFxuICAgICAgICAgICAgfSlcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHVzZXIgPSBhd2FpdCBkYi5FbXBsb3llZS5maW5kT25lKHsgXG4gICAgICAgICAgICAgICAgZW1haWwsIFxuICAgICAgICAgICAgICAgIGNvbXBhbnlJZCxcbiAgICAgICAgICAgICAgICBkZWxldGVkQXQ6IG51bGxcbiAgICAgICAgICAgIH0pXG4gICAgICAgIH1cbiAgICAgICAgaWYoIXVzZXIpe1xuICAgICAgICAgICAgdGhyb3cgbmV3IFJlcXVlc3RFcnJvcignaW52YWxpZCBlbWFpbElkIHJlY2lldmVkJyk7XG4gICAgICAgIH1cblxuICAgICAgICB1c2VyLnNldCh7XG4gICAgICAgICAgICB2ZXJmS2V5OiB0b2tlbixcbiAgICAgICAgICAgIHZlcmZLZXlFeHBpcnk6IG5ldyBEYXRlKClcbiAgICAgICAgfSlcbiAgICAgICAgYXdhaXQgdXNlci5zYXZlKCk7XG5cbiAgICAgICAgbGV0IGVuY3J5cHRFbWFpbCA9IGF3YWl0IGNyeXB0by5lbmNyeXB0KGVtYWlsKTtcbiAgICAgICAgZW5jcnlwdEVtYWlsID0gZW5jb2RlVVJJQ29tcG9uZW50KGVuY3J5cHRFbWFpbCk7XG4gICAgICAgIGF3YWl0IG1haWxlci5zZW5kUmVzZXRMaW5rKHVzZXIuZmlyc3ROYW1lLCBlbWFpbCwgZW5jcnlwdEVtYWlsLCB0b2tlbiwgY29tcGFueUlkKTsgICAgICAgIFxuXG4gICAgICAgIHJlcVsndXNlciddID0gdXNlcjtcbiAgICAgICAgdXNlckFjdGl2aXR5LmNyZWF0ZShyZXEsICdGb3Jnb3QgUGFzc3dvcmQnKTtcbiAgICAgICAgbG9nZ2VyLmluZm8oYFVzZXIgJHtlbWFpbH0gRm9yZ290IFBhc3N3b3JkYCwgeyBjbGllbnQ6IHVzZXIuY29tcGFueUlkLCByZXF1ZXN0OiByZXEsIGV2ZW50OiAnRm9yZ290IFBhc3N3b3JkJyB9KTtcblxuICAgICAgICByZXR1cm4gcmVzLnN0YXR1cygyMDApLnNlbmQoeyBzdWNjZXNzOiB0cnVlLCBtZXNzYWdlOiAncGFzc3dvcmQgcmVzZXQgbGluayBoYXMgYmVlbiBzZW50IHRvIHlvdSBlbWFpbElkJyB9KVxuICAgIH0gICBcbiAgICBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgY29uc29sZS5sb2coZXJyb3IpO1xuICAgICAgICBuZXh0KG5ldyBSZXF1ZXN0RXJyb3IoZXJyb3IpKVxuICAgIH1cbn1cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5wb3N0KGh0bWxzYW5pdGl6ZSgpLCB2YWxpZGF0ZUJvZHkodmFsaWRhdG9yKSwgY29udHJvbGxlcik7XG5leHBvcnQgZGVmYXVsdCBhcGlSb3V0ZXI7Il0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQSxJQUFJQSxTQUFTLEdBQUdDLGVBQUcsQ0FBQ0MsTUFBTSxFQUFFLENBQUNDLElBQUksQ0FBQztFQUNqQ0MsS0FBSyxFQUFFSCxlQUFHLENBQUNJLE1BQU0sRUFBRSxDQUFDRCxLQUFLLEVBQUUsQ0FBQ0UsUUFBUSxFQUFFO0VBQ3RDQyxTQUFTLEVBQUVOLGVBQUcsQ0FBQ0ksTUFBTSxFQUFFLENBQUNHLEdBQUcsRUFBRSxDQUFDQyxNQUFNLENBQUMsRUFBRSxDQUFDLENBQUNILFFBQVEsRUFBRTtFQUNuREksSUFBSSxFQUFFVCxlQUFHLENBQUNVLEdBQUcsRUFBRSxDQUFDQyxLQUFLLENBQUMsTUFBTSxFQUFFLFVBQVU7QUFDekMsQ0FBQyxDQUFDOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBSUEsSUFBSUMsVUFBVTtFQUFBLHlGQUFHLGlCQUFPQyxHQUFHLEVBQUVDLEdBQUcsRUFBRUMsSUFBSTtJQUFBO0lBQUE7TUFBQTtRQUFBO1VBQUE7VUFBQSxZQUVjRixHQUFHLENBQUNHLElBQUksRUFBNUNiLEtBQUssYUFBTEEsS0FBSyw2QkFBRU0sSUFBSSxFQUFKQSxJQUFJLCtCQUFHLE1BQU0sbUJBQUVILFNBQVMsYUFBVEEsU0FBUztVQUNuQ1csSUFBSSxHQUFHLElBQUksRUFBRUMsS0FBSyxHQUFHLElBQUFDLHVCQUFZLEVBQUMsRUFBRSxDQUFDO1VBQUEsTUFDdENWLElBQUksSUFBSSxNQUFNO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUNBVyxFQUFFLENBQUNDLEtBQUssQ0FBQ0MsT0FBTyxDQUFDO1lBQzFCbkIsS0FBSyxFQUFMQSxLQUFLO1lBQ0xHLFNBQVMsRUFBVEEsU0FBUztZQUNUaUIsU0FBUyxFQUFFO1VBQ2YsQ0FBQyxDQUFDO1FBQUE7VUFKRk4sSUFBSTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUEsT0FNU0csRUFBRSxDQUFDSSxRQUFRLENBQUNGLE9BQU8sQ0FBQztZQUM3Qm5CLEtBQUssRUFBTEEsS0FBSztZQUNMRyxTQUFTLEVBQVRBLFNBQVM7WUFDVGlCLFNBQVMsRUFBRTtVQUNmLENBQUMsQ0FBQztRQUFBO1VBSkZOLElBQUk7UUFBQTtVQUFBLElBTUpBLElBQUk7WUFBQTtZQUFBO1VBQUE7VUFBQSxNQUNFLElBQUlRLFlBQVksQ0FBQywwQkFBMEIsQ0FBQztRQUFBO1VBR3REUixJQUFJLENBQUNTLEdBQUcsQ0FBQztZQUNMQyxPQUFPLEVBQUVULEtBQUs7WUFDZFUsYUFBYSxFQUFFLElBQUlDLElBQUk7VUFDM0IsQ0FBQyxDQUFDO1VBQUE7VUFBQSxPQUNJWixJQUFJLENBQUNhLElBQUksRUFBRTtRQUFBO1VBQUE7VUFBQSxPQUVRQyxrQkFBTSxDQUFDQyxPQUFPLENBQUM3QixLQUFLLENBQUM7UUFBQTtVQUExQzhCLFlBQVk7VUFDaEJBLFlBQVksR0FBR0Msa0JBQWtCLENBQUNELFlBQVksQ0FBQztVQUFDO1VBQUEsT0FDMUNFLGtCQUFNLENBQUNDLGFBQWEsQ0FBQ25CLElBQUksQ0FBQ29CLFNBQVMsRUFBRWxDLEtBQUssRUFBRThCLFlBQVksRUFBRWYsS0FBSyxFQUFFWixTQUFTLENBQUM7UUFBQTtVQUVqRk8sR0FBRyxDQUFDLE1BQU0sQ0FBQyxHQUFHSSxJQUFJO1VBQ2xCcUIsb0JBQVksQ0FBQ0MsTUFBTSxDQUFDMUIsR0FBRyxFQUFFLGlCQUFpQixDQUFDO1VBQzNDMkIsTUFBTSxDQUFDQyxJQUFJLGdCQUFTdEMsS0FBSyx1QkFBb0I7WUFBRXVDLE1BQU0sRUFBRXpCLElBQUksQ0FBQ1gsU0FBUztZQUFFcUMsT0FBTyxFQUFFOUIsR0FBRztZQUFFK0IsS0FBSyxFQUFFO1VBQWtCLENBQUMsQ0FBQztVQUFDLGlDQUUxRzlCLEdBQUcsQ0FBQytCLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDO1lBQUVDLE9BQU8sRUFBRSxJQUFJO1lBQUVDLE9BQU8sRUFBRTtVQUFtRCxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUE7VUFHM0dDLE9BQU8sQ0FBQ0MsR0FBRyxhQUFPO1VBQ2xCbkMsSUFBSSxDQUFDLElBQUlVLFlBQVksYUFBTyxDQUFDO1FBQUE7UUFBQTtVQUFBO01BQUE7SUFBQTtFQUFBLENBRXBDO0VBQUEsZ0JBekNHYixVQUFVO0lBQUE7RUFBQTtBQUFBLEdBeUNiO0FBQ0QsSUFBTXVDLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDLElBQUFDLDBCQUFZLEdBQUUsRUFBRSxJQUFBQyx1QkFBWSxFQUFDMUQsU0FBUyxDQUFDLEVBQUVhLFVBQVUsQ0FBQztBQUFDLGVBQ2hFdUMsU0FBUztBQUFBIn0=