"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _jsonwebtoken = _interopRequireDefault(require("jsonwebtoken"));
var _config = _interopRequireDefault(require("../../config"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _strategy = require("../../middlewares/strategy");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var JWTSign = function JWTSign(iss, user, date, type, sudoPassword, companyFeatures) {
  return _jsonwebtoken["default"].sign({
    iss: _config["default"].app.name + '-' + iss,
    sub: user._id,
    type: type,
    iat: date.getTime(),
    AF: companyFeatures,
    exp: new Date().setMinutes(date.getMinutes() + 600),
    sudoPassword: sudoPassword ? sudoPassword : false
  }, _config["default"].app.secret);
};
var validator = _joi["default"].object().keys({
  email: _joi["default"].string().email().required(),
  password: _joi["default"].string().required(),
  companyId: _joi["default"].string().hex().length(24).required(),
  type: _joi["default"].any().valid('root', 'employee'),
  otp: _joi["default"].string().optional().allow(null).empty('')
});

/**
 * @api {post} /api/admin/login Login
 * @apiName LogIn
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} email       Required email of the User.
 * @apiBody {String} password    Required password of the User.
 * 
 *
 * @apiSuccess {String} success   true
 * @apiSuccess {String} token     token
 * @apiSuccess {String} type      type
 * @apiSuccess {String} name      name
 * @apiSuccess {String} message   successfully login
 * 
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {"success":true,
 *      "token":"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJUQUItVVNFUiIsInN1YiI6IjYzYWQ0NmNmNmI0MjlkYWE3YWE5YjY5OSIsInR5cGUiOiJyb290IiwiaWF0IjoxNjc0NTYwNTc5OTA3LCJleHAiOjE2OTI1NjA1Nzk5MDd9.4i8NVyOIT_P6lmWg3ZpCBzR9F7JvKkxDXqDYP804pq0",
 *      "type":"root",
 *      "name":"Sarvesh Patel",
 *      "message":["successfully login"]
 *      }
 * 
 * @apiError (404)  {String} status false
 * @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var type, company, companyFeatures, token;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          type = req.body.type; // if(!req.user.sudoPassword){
          //     userActivity.create(req, 'Login');
          //     logger.info(`User ${req.user.email} logged in`, { client: req.user.companyId, request: req, event: 'Logged In' });
          // }
          _context.next = 3;
          return db.Company.findById(req.user.companyId);
        case 3:
          company = _context.sent;
          _context.next = 6;
          return db.CompanyFeature.find({
            companyId: company._id
          }).select({
            _id: 0,
            featureCode: 1
          });
        case 6:
          companyFeatures = _context.sent;
          companyFeatures = companyFeatures.map(function (feature) {
            return feature.featureCode;
          });
          token = JWTSign('USER', req.user, new Date(), type, req.user.sudoPassword, companyFeatures);
          res.cookie('login_token', token, {
            httpOnly: true,
            secure: true,
            sameSite: 'Strict',
            maxAge: 180 * 60 * 1000
          });
          return _context.abrupt("return", res.status(200).json({
            success: true,
            token: true,
            type: type,
            emai: req.user.email,
            name: req.user.firstName,
            isURL: company.logo ? true : false,
            loginVia: 'TOOL',
            url: "".concat(_config["default"].app.url, "/api/static/logo/").concat(company.logo),
            isTacEnabled: company.isTacEnabled ? company.isTacEnabled : false,
            message: ["successfully login"]
          }));
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.localStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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