"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
/**
 * @api {get} /api/admin/logout Logout
 * @apiName logout
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {String} success   true
 * @apiSuccess {String} message   successfully Logout
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"successfully Logout"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$user;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          if (!req.user.sudoPassword) {
            _auditLog["default"].create(req, 'Logout');
          }
          if ((_req$user = req.user) !== null && _req$user !== void 0 && _req$user.email) {
            logger.info("User ".concat(req.user.email, " logged out"), {
              client: req.user.companyId,
              request: req,
              event: 'Logged Out'
            });
          }
          if (!(req.user.type == 'root')) {
            _context.next = 7;
            break;
          }
          _context.next = 5;
          return db.Admin.updateOne({
            email: req.user.email
          }, {
            loggedIn: false
          });
        case 5:
          _context.next = 9;
          break;
        case 7:
          _context.next = 9;
          return db.Employee.updateOne({
            email: req.user.email
          }, {
            loggedIn: false
          });
        case 9:
          res.clearCookie('login_token', {
            httpOnly: true,
            secure: true,
            sameSite: 'Strict'
          });
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "successfully Logout"
          }));
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtLogoutStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsInVzZXIiLCJzdWRvUGFzc3dvcmQiLCJ1c2VyQWN0aXZpdHkiLCJjcmVhdGUiLCJlbWFpbCIsImxvZ2dlciIsImluZm8iLCJjbGllbnQiLCJjb21wYW55SWQiLCJyZXF1ZXN0IiwiZXZlbnQiLCJ0eXBlIiwiZGIiLCJBZG1pbiIsInVwZGF0ZU9uZSIsImxvZ2dlZEluIiwiRW1wbG95ZWUiLCJjbGVhckNvb2tpZSIsImh0dHBPbmx5Iiwic2VjdXJlIiwic2FtZVNpdGUiLCJzdGF0dXMiLCJqc29uIiwic3VjY2VzcyIsIm1lc3NhZ2UiLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJnZXQiLCJzYW5pdGl6ZSIsImp3dExvZ291dFN0cmF0ZWd5Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9hZG1pbi9sb2dvdXQuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGV4cHJlc3MgZnJvbSAnZXhwcmVzcyc7XG5cbmltcG9ydCB1c2VyQWN0aXZpdHkgZnJvbSAnLi4vLi4vc2VydmljZS9hdWRpdC1sb2cnO1xuaW1wb3J0IHsgc2FuaXRpemUgfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9zYW5pdGl6ZXInO1xuaW1wb3J0IHsgand0TG9nb3V0U3RyYXRlZ3kgfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9zdHJhdGVneSc7XG5cbi8qKlxuICogQGFwaSB7Z2V0fSAvYXBpL2FkbWluL2xvZ291dCBMb2dvdXRcbiAqIEBhcGlOYW1lIGxvZ291dFxuICogQGFwaUdyb3VwIEF1dGhlbnRpY2F0aW9uXG4gKiBcbiAqIEBhcGlWZXJzaW9uIDEuMC4wXG4gKiBcbiAqIEBhcGlTdWNjZXNzIHtTdHJpbmd9IHN1Y2Nlc3MgICB0cnVlXG4gKiBAYXBpU3VjY2VzcyB7U3RyaW5nfSBtZXNzYWdlICAgc3VjY2Vzc2Z1bGx5IExvZ291dFxuICogXG4gKiBAYXBpU3VjY2Vzc0V4YW1wbGUgU3VjY2Vzcy1SZXNwb25zZTpcbiAqICAgICBIVFRQLzEuMSAyMDAgT0tcbiAqICAgICB7XG4gKiAgICAgIFwic3VjY2Vzc1wiOnRydWUsXG4gKiAgICAgIFwibWVzc2FnZVwiOlwic3VjY2Vzc2Z1bGx5IExvZ291dFwiXG4gKiAgICAgIH1cbiAqIFxuICovXG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgaWYoIXJlcS51c2VyLnN1ZG9QYXNzd29yZCl7XG4gICAgdXNlckFjdGl2aXR5LmNyZWF0ZShyZXEsICdMb2dvdXQnKTtcbiAgICB9XG4gICAgaWYocmVxLnVzZXI/LmVtYWlsKXtcbiAgICAgICAgbG9nZ2VyLmluZm8oYFVzZXIgJHtyZXEudXNlci5lbWFpbH0gbG9nZ2VkIG91dGAsIHsgY2xpZW50OiByZXEudXNlci5jb21wYW55SWQsIHJlcXVlc3Q6IHJlcSwgZXZlbnQ6ICdMb2dnZWQgT3V0JyB9KTtcbiAgICB9XG4gICAgXG4gICAgaWYocmVxLnVzZXIudHlwZSA9PSAncm9vdCcpIGF3YWl0IGRiLkFkbWluLnVwZGF0ZU9uZSh7ZW1haWw6IHJlcS51c2VyLmVtYWlsfSx7bG9nZ2VkSW46IGZhbHNlfSlcbiAgICBlbHNlIGF3YWl0IGRiLkVtcGxveWVlLnVwZGF0ZU9uZSh7ZW1haWw6IHJlcS51c2VyLmVtYWlsfSx7bG9nZ2VkSW46IGZhbHNlfSlcblxuICAgIHJlcy5jbGVhckNvb2tpZSgnbG9naW5fdG9rZW4nLCB7XG4gICAgICAgIGh0dHBPbmx5OiB0cnVlLFxuICAgICAgICBzZWN1cmU6IHRydWUsXG4gICAgICAgIHNhbWVTaXRlOiAnU3RyaWN0JyxcbiAgICB9KTtcblxuICAgIHJldHVybiByZXMuc3RhdHVzKDIwMCkuanNvbih7IHN1Y2Nlc3M6IHRydWUsIG1lc3NhZ2U6IFwic3VjY2Vzc2Z1bGx5IExvZ291dFwiIH0pO1xufVxuXG5jb25zdCBhcGlSb3V0ZXIgPSBleHByZXNzLlJvdXRlcigpO1xuYXBpUm91dGVyLnJvdXRlKCcvJykuZ2V0KHNhbml0aXplKCksIGp3dExvZ291dFN0cmF0ZWd5LCBjb250cm9sbGVyKTtcbmV4cG9ydCBkZWZhdWx0IGFwaVJvdXRlcjsiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBRUE7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLElBQUlBLFVBQVU7RUFBQSx5RkFBRyxpQkFBT0MsR0FBRyxFQUFFQyxHQUFHLEVBQUVDLElBQUk7SUFBQTtJQUFBO01BQUE7UUFBQTtVQUNsQyxJQUFHLENBQUNGLEdBQUcsQ0FBQ0csSUFBSSxDQUFDQyxZQUFZLEVBQUM7WUFDMUJDLG9CQUFZLENBQUNDLE1BQU0sQ0FBQ04sR0FBRyxFQUFFLFFBQVEsQ0FBQztVQUNsQztVQUNBLGlCQUFHQSxHQUFHLENBQUNHLElBQUksc0NBQVIsVUFBVUksS0FBSyxFQUFDO1lBQ2ZDLE1BQU0sQ0FBQ0MsSUFBSSxnQkFBU1QsR0FBRyxDQUFDRyxJQUFJLENBQUNJLEtBQUssa0JBQWU7Y0FBRUcsTUFBTSxFQUFFVixHQUFHLENBQUNHLElBQUksQ0FBQ1EsU0FBUztjQUFFQyxPQUFPLEVBQUVaLEdBQUc7Y0FBRWEsS0FBSyxFQUFFO1lBQWEsQ0FBQyxDQUFDO1VBQ3ZIO1VBQUMsTUFFRWIsR0FBRyxDQUFDRyxJQUFJLENBQUNXLElBQUksSUFBSSxNQUFNO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUFRQyxFQUFFLENBQUNDLEtBQUssQ0FBQ0MsU0FBUyxDQUFDO1lBQUNWLEtBQUssRUFBRVAsR0FBRyxDQUFDRyxJQUFJLENBQUNJO1VBQUssQ0FBQyxFQUFDO1lBQUNXLFFBQVEsRUFBRTtVQUFLLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQSxPQUNwRkgsRUFBRSxDQUFDSSxRQUFRLENBQUNGLFNBQVMsQ0FBQztZQUFDVixLQUFLLEVBQUVQLEdBQUcsQ0FBQ0csSUFBSSxDQUFDSTtVQUFLLENBQUMsRUFBQztZQUFDVyxRQUFRLEVBQUU7VUFBSyxDQUFDLENBQUM7UUFBQTtVQUUzRWpCLEdBQUcsQ0FBQ21CLFdBQVcsQ0FBQyxhQUFhLEVBQUU7WUFDM0JDLFFBQVEsRUFBRSxJQUFJO1lBQ2RDLE1BQU0sRUFBRSxJQUFJO1lBQ1pDLFFBQVEsRUFBRTtVQUNkLENBQUMsQ0FBQztVQUFDLGlDQUVJdEIsR0FBRyxDQUFDdUIsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUM7WUFBRUMsT0FBTyxFQUFFLElBQUk7WUFBRUMsT0FBTyxFQUFFO1VBQXNCLENBQUMsQ0FBQztRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUNqRjtFQUFBLGdCQWxCRzVCLFVBQVU7SUFBQTtFQUFBO0FBQUEsR0FrQmI7QUFFRCxJQUFNNkIsU0FBUyxHQUFHQyxtQkFBTyxDQUFDQyxNQUFNLEVBQUU7QUFDbENGLFNBQVMsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxHQUFHLENBQUMsSUFBQUMsbUJBQVEsR0FBRSxFQUFFQywyQkFBaUIsRUFBRW5DLFVBQVUsQ0FBQztBQUFDLGVBQ3JENkIsU0FBUztBQUFBIn0=