"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _registerCompanyTa = _interopRequireDefault(require("../../service/register-company-ta"));
var _packageHelper = _interopRequireDefault(require("../../service/package-helper"));
var validator = _joi["default"].object().keys({
  firstName: _joi["default"].string().required(),
  lastName: _joi["default"].string().required(),
  companyName: _joi["default"].string().required(),
  email: _joi["default"].string().email().required(),
  industry: _joi["default"].string().required(),
  country: _joi["default"].string().required()
  // password: Joi.string().min(8).max(16).required(),
  // confirmPassword: Joi.any().valid(Joi.ref('password')).required()
});

/**
 * @api {post} /api/admin/register Sign Up
 * @apiName register
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} name               Required name of the User.
 * @apiBody {String} companyName        Required companyName of the User.
 * @apiBody {String} email              Required email of the User.
 * @apiBody {String} password           Required password of the User.
 * @apiBody {String} confirmPassword    Required password of the User.
 * 
 * 
 * @apiSuccess {String} success   true
 * @apiSuccess {String} message   User successfully registered and verification mail has been send to your provided emailId
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {"success":true,
 *      "message":"User successfully registered and verification mail has been send to your provided emailId"
 *      }
 * 
 * @apiError (404)  {String} status false
 * @apiError (404)  {String} message ["Email already exists."] 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 403 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email already exists."]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _db$Company$create, _req$body, firstName, lastName, email, companyName, industry, country, verfKey, user, isCompanyExist, _yield$registerCompan, companyDetails, licenseDetails, packageDetails, company, admin, metaData, key, update, setPackage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, firstName = _req$body.firstName, lastName = _req$body.lastName, email = _req$body.email, companyName = _req$body.companyName, industry = _req$body.industry, country = _req$body.country;
          verfKey = (0, _functions.randomString)(10);
          _context.next = 5;
          return db.Admin.findOne({
            email: email,
            deletedAt: null
          });
        case 5:
          user = _context.sent;
          if (!user) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Email already exists.', 403);
        case 8:
          _context.next = 10;
          return db.Company.findOne({
            name: companyName
          });
        case 10:
          isCompanyExist = _context.sent;
          if (!isCompanyExist) {
            _context.next = 13;
            break;
          }
          throw new RequestError('Company already exists.', 403);
        case 13:
          _context.next = 15;
          return (0, _registerCompanyTa["default"])({
            appName: "TPIR",
            companyName: companyName,
            firstName: firstName,
            lastName: lastName,
            email: email,
            industry: industry,
            country: country
          });
        case 15:
          _yield$registerCompan = _context.sent;
          companyDetails = _yield$registerCompan.companyDetails;
          licenseDetails = _yield$registerCompan.licenseDetails;
          packageDetails = _yield$registerCompan.packageDetails;
          if (!(!companyDetails || !licenseDetails || !packageDetails)) {
            _context.next = 21;
            break;
          }
          throw new RequestError("Error registering company!");
        case 21:
          _context.next = 23;
          return db.Company.create((_db$Company$create = {
            alias: companyDetails === null || companyDetails === void 0 ? void 0 : companyDetails.alias,
            name: companyName,
            tacLicenseKey: licenseDetails === null || licenseDetails === void 0 ? void 0 : licenseDetails.licenseKey
          }, (0, _defineProperty2["default"])(_db$Company$create, "alias", companyDetails === null || companyDetails === void 0 ? void 0 : companyDetails.alias), (0, _defineProperty2["default"])(_db$Company$create, "tacCompanyId", companyDetails === null || companyDetails === void 0 ? void 0 : companyDetails.tacCompanyId), (0, _defineProperty2["default"])(_db$Company$create, "packageAccessKey", packageDetails === null || packageDetails === void 0 ? void 0 : packageDetails.packageAccessKey), (0, _defineProperty2["default"])(_db$Company$create, "isTacEnabled", true), _db$Company$create));
        case 23:
          company = _context.sent;
          _context.next = 26;
          return db.Admin.create({
            firstName: firstName,
            lastName: lastName,
            email: email,
            companyId: company._id,
            verfKey: verfKey,
            isTacEnabled: true,
            isActive: true,
            isVerify: true
          });
        case 26:
          admin = _context.sent;
          metaData = {
            tsatUrl: 'https://tsat.threatcop.com',
            isTsat: "false",
            mailSmtp: false,
            expiredAt: licenseDetails === null || licenseDetails === void 0 ? void 0 : licenseDetails.endDate,
            userLimit: licenseDetails === null || licenseDetails === void 0 ? void 0 : licenseDetails.emailUsersCount,
            userLimitMessenger: licenseDetails === null || licenseDetails === void 0 ? void 0 : licenseDetails.whatsappUsersCount,
            domainLimit: licenseDetails === null || licenseDetails === void 0 ? void 0 : licenseDetails.domainCount
          };
          _context.t0 = _regenerator["default"].keys(metaData);
        case 29:
          if ((_context.t1 = _context.t0()).done) {
            _context.next = 37;
            break;
          }
          key = _context.t1.value;
          _context.next = 33;
          return db.MetaData.findOneAndUpdate({
            companyId: company._id,
            name: key
          }, {
            value: metaData[key]
          }, {
            upsert: true,
            "new": true,
            setDefaultsOnInsert: true
          });
        case 33:
          update = _context.sent;
          console.log({
            update: update,
            key: key
          });
          _context.next = 29;
          break;
        case 37:
          _context.next = 39;
          return db.Group.create({
            groupName: "all-users-tpir",
            type: "Custom",
            isDefaultGroup: true,
            emailAccess: false,
            messengerAccess: false,
            companyId: company._id,
            createdAt: new Date('9999-12-31')
          });
        case 39:
          _context.next = 41;
          return _packageHelper["default"].syncPackageDetails(company);
        case 41:
          setPackage = _context.sent;
          req['user'] = admin;
          _auditLog["default"].create(req, 'Registerd');
          logger.info("User ".concat(email, " register"), {
            client: company._id,
            request: req,
            event: 'Registerd'
          });
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "User successfully registered and verification mail has been send to your provided emailId"
          }));
        case 48:
          _context.prev = 48;
          _context.t2 = _context["catch"](0);
          console.log(_context.t2);
          next(_context.t2);
        case 52:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 48]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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