"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _functions = require("../../functions");
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  companyId: _joi["default"].string().hex().length(24).required(),
  email: _joi["default"].string().email().required(),
  type: _joi["default"].any().valid('root', 'employee').required()
});

/**
 * @api {post} /api/admin/resend-otp Check Company
 * @apiName resend-otp
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} email                      Required email of the User.
 * @apiBody {String=root,employee} type=root    Required type of the User.
 * @apiBody {String} companyId                  Required companyId of the User.
 * 
 * 
 * @apiSuccess {Boolean} success   true
 * @apiSuccess {String}  message   successfully validate company
 * @apiSuccess {Boolean} isOtp     false
 * @apiSuccess {String}  otpType   Type of Otp
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *    {
 *       "success": true,
 *       "message": "successfully validate company"
 *      }
 * 
 * 
 * @apiError (400)  {String} status  false
 * @apiError (400)  {String} message \"companyId\" length must be 24 characters long
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *     {
 *      "success":false,
 *      "messages":["\"companyId\" length must be 24 characters long"]
 *      }
 * 
 *  @apiError (404)  {String} status false
 *  @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, type, companyId, user, otp, otpExpiry;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, type = _req$body.type, companyId = _req$body.companyId;
          user = null;
          if (!(type == 'root')) {
            _context.next = 9;
            break;
          }
          _context.next = 6;
          return db.Admin.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 6:
          user = _context.sent;
          _context.next = 12;
          break;
        case 9:
          _context.next = 11;
          return db.Employee.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 11:
          user = _context.sent;
        case 12:
          if (user) {
            _context.next = 14;
            break;
          }
          throw new RequestError('Email not found in TPIR database please register through this email and then use', 404);
        case 14:
          if (!(user.security && user.security.status)) {
            _context.next = 23;
            break;
          }
          if (!(user.security.otpType == 'MAIL')) {
            _context.next = 23;
            break;
          }
          otp = (0, _functions.randomString)(10);
          otpExpiry = new Date();
          _context.next = 20;
          return _mailer["default"].sendOTP(user.firstName, user.email, otp, companyId);
        case 20:
          user.set({
            'security.otp': otp,
            'security.otpExpiry': otpExpiry
          });
          _context.next = 23;
          return user.save();
        case 23:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "OTP has been sent to your emailId"
          }));
        case 26:
          _context.prev = 26;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 30:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 26]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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