"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _mailer = _interopRequireDefault(require("../../mailer"));
var validator = _joi["default"].object().keys({
  token: _joi["default"].string().required(),
  email: _joi["default"].string().required(),
  password: _joi["default"].string().min(8).max(16).required(),
  confirmPassword: _joi["default"].any().valid(_joi["default"].ref('password')).required(),
  isResettingPassword: _joi["default"]["boolean"]().optional()
});

/**
 * @api {post} /api/admin/reset-password Reset Password
 * @apiName reset-password
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} token               Required token sent in mail.
 * @apiBody {String} email               Required email of the user.
 * @apiBody {String} password            Required new password of the User.
 * @apiBody {String} password            Required confirm password of the User.
 *
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} Message     Password Updated Successfully!
 * 
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "Message":"Password Updated Successfully!"
 *      }
 * 
 * @apiError (500)  {String} success   false
 * @apiError (500)  {Array}  messages  Invalid emailId or token recieved
 *
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *  {
 *  "success": false,
 *  "messages": [
 *      {
 *          "status": 500,
 *          "errorList": [
 *              "Invalid emailId or token recieved"
 *          ]
 *      }
 *   ]
 *   }
 *
 * 
 * @apiError (500)  {String} status  false
 * @apiError (500)  {String} message password reset link has been expired
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *  {
 *  "success": false,
 *  "messages": [
 *      {
 *          "status": 500,
 *          "errorList": [
 *              "password reset link has been expired"
 *          ]
 *      }
 *   ]
 *   }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, token, password, _req$body$isResetting, isResettingPassword, user, type, encryptEmail, isSamePassword;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, token = _req$body.token, password = _req$body.password, _req$body$isResetting = _req$body.isResettingPassword, isResettingPassword = _req$body$isResetting === void 0 ? false : _req$body$isResetting;
          user = null, type = 'root';
          _context.next = 5;
          return _crypto["default"].decrypt(email);
        case 5:
          encryptEmail = _context.sent;
          encryptEmail = decodeURIComponent(encryptEmail);
          _context.next = 9;
          return db.Admin.findOne({
            email: encryptEmail,
            verfKey: token
          });
        case 9:
          user = _context.sent;
          if (user) {
            _context.next = 15;
            break;
          }
          type = 'employee';
          _context.next = 14;
          return db.Employee.findOne({
            email: encryptEmail,
            verfKey: token
          });
        case 14:
          user = _context.sent;
        case 15:
          if (user) {
            _context.next = 17;
            break;
          }
          throw new RequestError('Invalid emailId or token recieved');
        case 17:
          if (!(user.verfKeyExpiry.getTime() < new Date().getTime() - 30 * 60 * 1000)) {
            _context.next = 19;
            break;
          }
          throw new RequestError('password reset link has been expired');
        case 19:
          if (!user.password) {
            _context.next = 23;
            break;
          }
          isSamePassword = _bcryptjs["default"].compareSync(password, user.password);
          if (!isSamePassword) {
            _context.next = 23;
            break;
          }
          throw new RequestError('New password must differ from the current password.');
        case 23:
          user.set({
            attempt: 0,
            verfKey: null,
            isVerify: true,
            isActive: true,
            verfKeyExpiry: null,
            password: _bcryptjs["default"].hashSync(password),
            loggedIn: false
          });
          _context.next = 26;
          return user.save();
        case 26:
          if (isResettingPassword) {
            _context.next = 29;
            break;
          }
          _context.next = 29;
          return _mailer["default"].sendSuccessRegister(user.name, encryptEmail, user.companyId);
        case 29:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Password Updated Successfully!'
          }));
        case 32:
          _context.prev = 32;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(new RequestError(_context.t0));
        case 36:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 32]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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