"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _axios = _interopRequireDefault(require("axios"));
var _express = _interopRequireDefault(require("express"));
var _jsonwebtoken = _interopRequireDefault(require("jsonwebtoken"));
var _config = _interopRequireDefault(require("../../config"));
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var JWTSign = function JWTSign(iss, user, date, type, sudoPassword, companyFeatures) {
  return _jsonwebtoken["default"].sign({
    iss: _config["default"].app.name + '-' + iss,
    sub: user._id,
    type: type,
    iat: date.getTime(),
    AF: companyFeatures,
    exp: new Date().setMinutes(date.getMinutes() + 600),
    sudoPassword: sudoPassword ? sudoPassword : false
  }, _config["default"].app.secret);
};
var validator = _joi["default"].object().keys({
  tacToken: _joi["default"].string().required()
});
var validateTacToken = function validateTacToken(token) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve, reject) {
      var config;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            config = _objectSpread({
              method: 'POST',
              url: "".concat(process.env.TAC_URL, "/api/auth/validate"),
              headers: {
                Authorization: "Bearer ".concat(token)
              },
              data: {
                applicationName: 'TPIR'
              }
            }, config.proxy.enableForTA && {
              httpsAgent: config.proxy.proxyAgent,
              httpAgent: config.proxy.proxyAgent
            });
            _axios["default"].request(config).then(function (res) {
              resolve({
                userId: res.data.response.userId,
                companyId: res.data.response.companyId,
                type: res.data.response.type
              });
            })["catch"](function (err) {
              reject(err);
            });
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x, _x2) {
      return _ref.apply(this, arguments);
    };
  }());
};

/**
 * @api {post} /api/admin/login Login
 * @apiName LogIn
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} email       Required email of the User.
 * @apiBody {String} password    Required password of the User.
 * 
 *
 * @apiSuccess {String} success   true
 * @apiSuccess {String} token     token
 * @apiSuccess {String} type      type
 * @apiSuccess {String} name      name
 * @apiSuccess {String} message   successfully login
 * 
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {"success":true,
 *      "token":"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJUQUItVVNFUiIsInN1YiI6IjYzYWQ0NmNmNmI0MjlkYWE3YWE5YjY5OSIsInR5cGUiOiJyb290IiwiaWF0IjoxNjc0NTYwNTc5OTA3LCJleHAiOjE2OTI1NjA1Nzk5MDd9.4i8NVyOIT_P6lmWg3ZpCBzR9F7JvKkxDXqDYP804pq0",
 *      "type":"root",
 *      "name":"Sarvesh Patel",
 *      "message":["successfully login"]
 *      }
 * 
 * @apiError (404)  {String} status false
 * @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var tacToken, _yield$validateTacTok, userId, companyId, type, user, company, companyFeatures, token;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          tacToken = req.body.tacToken;
          _context2.next = 4;
          return validateTacToken(tacToken);
        case 4:
          _yield$validateTacTok = _context2.sent;
          userId = _yield$validateTacTok.userId;
          companyId = _yield$validateTacTok.companyId;
          type = _yield$validateTacTok.type;
          if (!(type == 'root')) {
            _context2.next = 14;
            break;
          }
          _context2.next = 11;
          return db.Admin.findOne({
            _id: userId,
            companyId: companyId
          });
        case 11:
          user = _context2.sent;
          _context2.next = 17;
          break;
        case 14:
          _context2.next = 16;
          return db.Employee.findOne({
            _id: userId,
            companyId: companyId
          });
        case 16:
          user = _context2.sent;
        case 17:
          if (user) {
            _context2.next = 19;
            break;
          }
          throw new RequestError('User not found!', 404);
        case 19:
          _context2.next = 21;
          return db.Company.findById(companyId);
        case 21:
          company = _context2.sent;
          if (company) {
            _context2.next = 24;
            break;
          }
          throw new RequestError('Company not found!', 404);
        case 24:
          _context2.next = 26;
          return db.CompanyFeature.find({
            companyId: company._id
          }).select({
            _id: 0,
            featureCode: 1
          });
        case 26:
          companyFeatures = _context2.sent;
          companyFeatures = companyFeatures.map(function (feature) {
            return feature.featureCode;
          });
          token = JWTSign('USER', user, new Date(), type, false, companyFeatures);
          if (!(type == 'root')) {
            _context2.next = 34;
            break;
          }
          _context2.next = 32;
          return db.Admin.updateOne({
            _id: userId
          }, {
            loggedIn: true
          });
        case 32:
          _context2.next = 36;
          break;
        case 34:
          _context2.next = 36;
          return db.Employee.updateOne({
            _id: userId
          }, {
            loggedIn: true
          });
        case 36:
          res.cookie('login_token', token, {
            httpOnly: true,
            secure: true,
            sameSite: 'Strict',
            maxAge: 180 * 60 * 1000
          });
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            token: true,
            email: user.email,
            isTacEnabled: company === null || company === void 0 ? void 0 : company.isTacEnabled,
            tacUrl: _config["default"].adminCentral.url,
            loginVia: 'TAC',
            type: type,
            name: user.firstName,
            isURL: company.logo ? true : false,
            url: "".concat(_config["default"].app.url, "/api/static/logo/").concat(company.logo),
            message: ["successfully login"]
          }));
        case 40:
          _context2.prev = 40;
          _context2.t0 = _context2["catch"](0);
          next(_context2.t0);
        case 43:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 40]]);
  }));
  return function controller(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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