"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
/**
 * @api {post} /api/admin/update-config update-config
 * @apiName update-config
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody (login) {Object} Configuration       Configuration of User
 * 
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} message     Updated Configuration successfully!  
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message": "Updated Configuration successfully!"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var config;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          config = req.body;
          _context.next = 4;
          return db.Company.findOneAndUpdate({
            _id: req.user.companyId
          }, {
            configuration: config
          }, {
            "new": true
          });
        case 4:
          res.status(200).send({
            success: true,
            message: "Updated Configuration successfully!"
          });
          _context.next = 11;
          break;
        case 7:
          _context.prev = 7;
          _context.t0 = _context["catch"](0);
          console.log("error", _context.t0);
          next(new RequestError(_context.t0));
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 7]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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