"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _permission = require("../../middlewares/permission");
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  socMail: _joi["default"].array().items(_joi["default"].string().email({
    tlds: {
      allow: false
    }
  })).required()
});

/**
 * @api {post} /api/admin/update-soc-mail Update Soc
 * @apiName update-soc-mail
 * @apiGroup Authentication
 * 
 * @apiBody (login)  {String} Soc Email   Required Soc Mail for the company    
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} message     Soc Email updated successfully
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message": "Soc Email updated successfully"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var socMail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          socMail = req.body.socMail;
          _context.next = 4;
          return db.Company.findOneAndUpdate({
            _id: req.user.companyId
          }, {
            socEmail: socMail
          }, {
            "new": true
          });
        case 4:
          _auditLog["default"].create(req, 'Soc Email Update', JSON.stringify(socMail));
          logger.info("User ".concat(req.user.email, " Soc Email Update"), {
            client: req.user.companyId,
            request: req,
            event: 'Soc Email Update'
          });
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'SOC Email updated successfully'
          }));
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 13:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').patch((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _validator.validateBody)(validator), (0, _permission.permission)('Users', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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