"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  email: _joi["default"].string().email().required(),
  token: _joi["default"].string().required()
});

/**
 * @api {post} /api/admin/verify-email Verify Email
 * @apiName verify-email
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String}    email     Required email of the User.
 * @apiBody {String}    token     Required token sent in mail
 * 
 * @apiSuccess {Boolean} success-1   true
 * @apiSuccess {String}  message-1   email successfully verified
 * @apiSuccess {Boolean} success-2   true
 * @apiSuccess {String}  message-2   You are Already Verified. You can proceed to login!
 *  
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"email successfully verified"
 *      }
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"You are Already Verified. You can proceed to login!"
 *      }
 *
 * 
 * @apiError (500)  {String} success-1   false
 * @apiError (500)  {Array}  messages-1  not a valid emailId
 * @apiError (500)  {String} success-2   false
 * @apiError (500)  {Array}  messages-2  invalid token
 *
 *
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "not a valid emailId"
 *           ]
 *        }
 *
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
         {
             "success": false,
             "messages": [
                 "invalid token"
             ]
         }
  */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, token, user;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, token = _req$body.token;
          _context.next = 4;
          return db.Admin.findOne({
            email: email
          });
        case 4:
          user = _context.sent;
          if (user) {
            _context.next = 7;
            break;
          }
          throw new RequestError('not a valid emailId');
        case 7:
          if (!user.isVerify) {
            _context.next = 9;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "You are Already Verified. You may proceed to login!"
          }));
        case 9:
          if (!(user.verfKey == token)) {
            _context.next = 14;
            break;
          }
          _context.next = 12;
          return db.Admin.findOneAndUpdate({
            _id: user._id
          }, {
            verfKey: null,
            isVerify: true,
            isActive: true
          });
        case 12:
          _context.next = 15;
          break;
        case 14:
          throw new RequestError('invalid token or url');
        case 15:
          req['user'] = user;
          _auditLog["default"].create(req, 'Verify Email');
          logger.info("User ".concat(email, " Verify Email"), {
            client: user.companyId,
            request: req,
            event: 'Verify Email'
          });
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'email verified successfully'
          }));
        case 21:
          _context.prev = 21;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 25:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 21]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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