"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  token: _joi["default"].string().required(),
  email: _joi["default"].string().required()
});

/**
 * @api {post} /api/admin/reset-password Reset Password
 * @apiName reset-password
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} token               Required token sent in mail.
 * @apiBody {String} email               Required email of the user.
 * @apiBody {String} password            Required new password of the User.
 * @apiBody {String} password            Required confirm password of the User.
 *
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} Message     Password Updated Successfully!
 * 
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "Message":"Password Updated Successfully!"
 *      }
 * 
 * @apiError (500)  {String} success   false
 * @apiError (500)  {Array}  messages  Invalid emailId or token recieved
 *
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *  {
 *  "success": false,
 *  "messages": [
 *      {
 *          "status": 500,
 *          "errorList": [
 *              "Invalid emailId or token recieved"
 *          ]
 *      }
 *   ]
 *   }
 *
 * 
 * @apiError (500)  {String} status  false
 * @apiError (500)  {String} message password reset link has been expired
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *  {
 *  "success": false,
 *  "messages": [
 *      {
 *          "status": 500,
 *          "errorList": [
 *              "password reset link has been expired"
 *          ]
 *      }
 *   ]
 *   }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, token, user, type, encryptEmail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, token = _req$body.token;
          user = null, type = 'root';
          console.log({
            email: email
          });
          _context.next = 6;
          return _crypto["default"].decrypt(email);
        case 6:
          encryptEmail = _context.sent;
          console.log({
            encryptEmail: encryptEmail
          });
          encryptEmail = decodeURIComponent(encryptEmail);
          console.log({
            encryptEmail: encryptEmail
          });
          _context.next = 12;
          return db.Admin.findOne({
            email: encryptEmail,
            verfKey: token
          });
        case 12:
          user = _context.sent;
          if (user) {
            _context.next = 18;
            break;
          }
          type = 'employee';
          _context.next = 17;
          return db.Employee.findOne({
            email: encryptEmail,
            verfKey: token
          });
        case 17:
          user = _context.sent;
        case 18:
          console.log({
            user: user
          });
          if (!(user && user.verfKeyExpiry && user.verfKeyExpiry.getTime() < new Date().getTime() - 30 * 60 * 1000)) {
            _context.next = 21;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            isTokenValid: false
          }));
        case 21:
          if (user) {
            _context.next = 23;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            isTokenValid: false
          }));
        case 23:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            isTokenValid: true
          }));
        case 26:
          _context.prev = 26;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(new RequestError(_context.t0));
        case 30:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 26]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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