"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _syncDomains = require("../../service/syncDomains");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
//specific group me user daal ra hain

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, api_key, groupDetails, userDetails, companyId, syncDomains, group, syncData, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, api_key = _req$body.api_key, groupDetails = _req$body.groupDetails, userDetails = _req$body.userDetails;
          console.log("Reached Here New", api_key, groupDetails, userDetails);
          if (!(api_key !== _config["default"].adminCentral.api_key || !api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 5:
          companyId = groupDetails.localCompanyId;
          _context.next = 8;
          return (0, _syncDomains.syncDomainsFromTa)(companyId);
        case 8:
          syncDomains = _context.sent;
          _context.next = 11;
          return db.Group.findOne({
            tacIdentityKey: groupDetails.identityKey
          });
        case 11:
          group = _context.sent;
          console.log({
            group: group
          });
          if (!group) {
            _context.next = 18;
            break;
          }
          _context.next = 16;
          return db.Group.updateOne({
            _id: group._id
          }, {
            $set: {
              tacIdentityKey: groupDetails.identityKey
            }
          });
        case 16:
          _context.next = 19;
          break;
        case 18:
          throw new RequestError("Group not found!", 404);
        case 19:
          syncData = {
            users: userDetails,
            companyId: companyId,
            groupId: group._id,
            lastSyncId: groupDetails === null || groupDetails === void 0 ? void 0 : groupDetails.lastSyncId,
            isLastBatch: true
          };
          _kue.queue.create('add-users-tac', _objectSpread({}, syncData)).priority('normal').removeOnComplete(true).save();
          res.status(200).json({
            message: "sucess"
          });
          _context.next = 31;
          break;
        case 24:
          _context.prev = 24;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 24]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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