"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _syncDomains = require("../../service/syncDomains");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
//ek group me user hain ab dusre group me bhi same user daalna
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, api_key, groupDetails, userDetails, companyId, syncDomains, group, syncData, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, api_key = _req$body.api_key, groupDetails = _req$body.groupDetails, userDetails = _req$body.userDetails;
          if (!(api_key !== _config["default"].adminCentral.api_key || !api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 4:
          companyId = groupDetails.localCompanyId;
          console.log("The company id is", companyId, groupDetails.tacGroupId);
          _context.next = 8;
          return (0, _syncDomains.syncDomainsFromTa)(companyId);
        case 8:
          syncDomains = _context.sent;
          _context.next = 11;
          return db.Group.findOne({
            tacIdentityKey: groupDetails.identityKey
          });
        case 11:
          group = _context.sent;
          if (group) {
            _context.next = 14;
            break;
          }
          throw new RequestError("Group not found!");
        case 14:
          if (!group) {
            _context.next = 17;
            break;
          }
          _context.next = 17;
          return db.Group.updateOne({
            _id: group._id
          }, {
            $set: {
              tacIdentityKey: groupDetails.identityKey
            }
          });
        case 17:
          syncData = {
            users: userDetails === null || userDetails === void 0 ? void 0 : userDetails.map(function (user) {
              return {
                email: user === null || user === void 0 ? void 0 : user.userEmail,
                IdentityKey: user === null || user === void 0 ? void 0 : user.IdentityKey
              };
            }),
            companyId: companyId,
            groupId: group._id,
            lastSyncId: groupDetails === null || groupDetails === void 0 ? void 0 : groupDetails.lastSyncId,
            isLastBatch: true
          };
          _kue.queue.create("add-users-tac", _objectSpread({}, syncData)).priority('normal').removeOnComplete(true).save();
          res.status(200).json({
            message: "sucess"
          });
          _context.next = 29;
          break;
        case 22:
          _context.prev = 22;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 29:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 22]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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