"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _syncDomains = require("../../service/syncDomains");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, licenseKey, company, individualUserGroup, allUsersGroup;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          licenseKey = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (licenseKey) {
            _context.next = 4;
            break;
          }
          throw new RequestError('License key not received.', 401);
        case 4:
          _context.next = 6;
          return db.Company.findOne({
            tacLicenseKey: licenseKey
          });
        case 6:
          company = _context.sent;
          if (company && company.isTacEnabled) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Threatcop Admin is already disconnected.', 400);
        case 9:
          _context.next = 11;
          return db.Group.findOne({
            groupName: "Individual-Users",
            type: "Admin",
            companyId: company === null || company === void 0 ? void 0 : company._id,
            deletedAt: null
          });
        case 11:
          individualUserGroup = _context.sent;
          _context.next = 14;
          return db.Group.findOne({
            groupName: 'all-useres-tpir',
            isDefaultGroup: true,
            companyId: company === null || company === void 0 ? void 0 : company._id,
            deletedAt: null
          });
        case 14:
          allUsersGroup = _context.sent;
          _context.next = 17;
          return db.Group.updateMany({
            companyId: company._id,
            type: "Custom",
            deletedAt: null
          }, {
            $set: {
              type: "Admin"
            }
          });
        case 17:
          if (!individualUserGroup) {
            _context.next = 22;
            break;
          }
          _context.next = 20;
          return db.User.updateMany({
            companyId: company._id
          }, {
            $pull: {
              groups: individualUserGroup._id
            },
            $set: {
              isActive: false,
              isActiveMessenger: false
            }
          });
        case 20:
          _context.next = 22;
          return db.Group.deleteOne({
            _id: individualUserGroup._id,
            companyId: company._id
          });
        case 22:
          _context.next = 24;
          return db.Company.updateOne({
            _id: company._id
          }, {
            $set: {
              isTacEnabled: false,
              isTaConnectionInProgess: false
            }
          });
        case 24:
          return _context.abrupt("return", res.status(200).json({
            success: 'true',
            message: 'Disconnected successfully.'
          }));
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](0);
          next(_context.t0);
        case 30:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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