"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var _syncDomains = require("../../service/syncDomains");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
//ye all-users-tpir group me daalegi users bhejke

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, api_key, userDetails, localCompanyId, identityKey, lastSyncId, group, _group, syncDomains, syncData, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$body = req.body, api_key = _req$body.api_key, userDetails = _req$body.userDetails, localCompanyId = _req$body.localCompanyId, identityKey = _req$body.identityKey, lastSyncId = _req$body.lastSyncId;
          _context.prev = 1;
          console.log("userDetails", userDetails);
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 5:
          _context.next = 7;
          return db.Group.findOne({
            tacIdentityKey: identityKey
          });
        case 7:
          group = _context.sent;
          if (group) {
            _context.next = 21;
            break;
          }
          _context.next = 11;
          return db.Group.findOne({
            groupName: 'Individual-Users',
            companyId: localCompanyId,
            tacIdentityKey: identityKey
          });
        case 11:
          group = _context.sent;
          if (group) {
            _context.next = 18;
            break;
          }
          _context.next = 15;
          return db.Group.create({
            groupName: 'Individual-Users',
            companyId: localCompanyId,
            tacIdentityKey: identityKey,
            type: "Admin"
          });
        case 15:
          group = _context.sent;
          _context.next = 21;
          break;
        case 18:
          _context.next = 20;
          return db.Group.updateOne({
            _id: _group.id
          }, {
            $set: {
              tacIdentityKey: identityKey,
              type: "Admin"
            }
          });
        case 20:
          _group = _context.sent;
        case 21:
          _context.next = 23;
          return (0, _syncDomains.syncDomainsFromTa)(localCompanyId);
        case 23:
          syncDomains = _context.sent;
          syncData = {
            users: userDetails,
            companyId: localCompanyId,
            groupId: group._id,
            lastSyncId: lastSyncId,
            isLastBatch: true
          };
          _kue.queue.create("add-users-tac", _objectSpread({}, syncData)).priority('normal').removeOnComplete(true).save();
          return _context.abrupt("return", res.status(200).json({
            message: "success",
            data: group.id
          }));
        case 29:
          _context.prev = 29;
          _context.t0 = _context["catch"](1);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 36:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 29]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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