"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, api_key, userDetails, localCompanyId, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          userDetails = req.body.userDetails;
          if (!(userDetails.length == 0)) {
            _context.next = 7;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "No User has been recevied to update"
          }));
        case 7:
          localCompanyId = userDetails[0].localCompanyId;
          userDetails = userDetails.map(function (_ref2) {
            var identityKey = _ref2.identityKey,
              firstName = _ref2.firstName,
              lastName = _ref2.lastName,
              phoneNumber = _ref2.phoneNumber;
            return {
              firstname: firstName,
              lastname: lastName,
              tacIdentityKey: identityKey,
              phone: phoneNumber
            };
          });
          _kue.queue.create('update-bulk-users', {
            companyId: localCompanyId,
            userDetails: userDetails
          }).removeOnComplete(true).save();
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Batch user update initiated successfully"
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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