"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, firstName, lastName, roleId, api_key, meta, IdentityKey, companyId, isHyperLink, verfKey, checkEmployee, passwordHash, decryptedPassword, newEmployee, EmployeeRole, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$body = req.body, email = _req$body.email, firstName = _req$body.firstName, lastName = _req$body.lastName, roleId = _req$body.roleId, api_key = _req$body.api_key, meta = _req$body.meta, IdentityKey = _req$body.IdentityKey;
          companyId = req.params.companyId;
          _context.prev = 2;
          console.log("api_key", api_key);
          console.log("api_key-env", _config["default"].adminCentral.api_key);
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 7;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 7:
          if (companyId) {
            _context.next = 9;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 9:
          email = (0, _sanitizeHtml["default"])(email);
          firstName = (0, _sanitizeHtml["default"])(firstName);
          lastName = (0, _sanitizeHtml["default"])(lastName);
          console.log(email);
          console.log(firstName);
          console.log(lastName);
          if (email.length) {
            _context.next = 19;
            break;
          }
          throw new RequestError("Email is empty after sanitizing!");
        case 19:
          if (firstName.length) {
            _context.next = 21;
            break;
          }
          throw new RequestError("First Name is empty after sanitizing!");
        case 21:
          //else if (!lastName.length) throw new RequestError("Last Name is empty after sanitizing!")
          isHyperLink = /^[a-zA-Z]+$/;
          if (isHyperLink.test(firstName)) {
            _context.next = 24;
            break;
          }
          throw new RequestError("First name cannot be a hyperlink!");
        case 24:
          //if(!isHyperLink.test(lastName)) throw new RequestError("Last name cannot be a hyperlink!")
          verfKey = (0, _functions.randomString)(10);
          _context.next = 27;
          return db.Employee.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 27:
          checkEmployee = _context.sent;
          if (!checkEmployee) {
            _context.next = 32;
            break;
          }
          _context.next = 31;
          return db.Employee.updateOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              tacIdentityKey: IdentityKey
            }
          });
        case 31:
          throw new RequestError("Same email already exists please try with another email!");
        case 32:
          passwordHash = '';
          if (!meta) {
            _context.next = 39;
            break;
          }
          decryptedPassword = _crypto["default"].decrypt(meta, _config["default"].adminCentral.crypto_secret);
          if (decryptedPassword) {
            _context.next = 37;
            break;
          }
          throw new RequestError('Request from invalid source, meta decryption failed.', 409);
        case 37:
          console.log({
            aaaa: decryptedPassword
          });
          passwordHash = _bcryptjs["default"].hashSync(decryptedPassword);
        case 39:
          _context.next = 41;
          return db.Employee.create({
            email: email,
            firstName: firstName,
            lastName: lastName,
            companyId: companyId,
            tacIdentityKey: IdentityKey,
            password: passwordHash,
            isVerify: true,
            isActive: true
          });
        case 41:
          newEmployee = _context.sent;
          _auditLog["default"].create(req, 'Add IAM User', email);
          _context.next = 45;
          return db.EmployeeRole.findOne({
            employeeId: newEmployee._id,
            companyId: companyId
          });
        case 45:
          EmployeeRole = _context.sent;
          if (EmployeeRole) {
            _context.next = 49;
            break;
          }
          _context.next = 49;
          return db.EmployeeRole.create({
            employeeId: newEmployee._id,
            roleIds: [roleId],
            companyId: companyId
          });
        case 49:
          return _context.abrupt("return", res.status(200).json({
            response: {
              email: email,
              userId: newEmployee._id
            }
          }));
        case 52:
          _context.prev = 52;
          _context.t0 = _context["catch"](2);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 59:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[2, 52]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/:companyId').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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