"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, _req$body, roleName, description, policyIds, companyId, api_key, isExistingRole, policyIdArr, i, id, Policy, Role, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, roleName = _req$body.roleName, description = _req$body.description, policyIds = _req$body.policyIds, companyId = _req$body.companyId;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(api_key !== _config["default"].adminCentral.api_key || !api_key)) {
            _context.next = 7;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 7:
          if (!(!roleName || !policyIds)) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Invalid Request', 400);
        case 9:
          _context.next = 11;
          return db.Role.findOne({
            roleName: roleName.toLowerCase(),
            companyId: companyId
          });
        case 11:
          isExistingRole = _context.sent;
          if (!isExistingRole) {
            _context.next = 14;
            break;
          }
          throw new RequestError("Role with same name already exists");
        case 14:
          policyIdArr = [];
          i = 0;
        case 16:
          if (!(i < policyIds.length)) {
            _context.next = 29;
            break;
          }
          id = policyIds[i];
          _context.next = 20;
          return db.Policy.findById(id);
        case 20:
          Policy = _context.sent;
          if (!(Policy && Policy._id)) {
            _context.next = 25;
            break;
          }
          policyIdArr.push(Policy._id);
          _context.next = 26;
          break;
        case 25:
          return _context.abrupt("continue", 26);
        case 26:
          i++;
          _context.next = 16;
          break;
        case 29:
          _context.next = 31;
          return db.Role.create({
            roleName: roleName.toLowerCase(),
            policyIds: policyIdArr,
            description: description,
            companyId: companyId
          });
        case 31:
          Role = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "".concat(roleName, " created successfully.")
          }));
        case 35:
          _context.prev = 35;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 42:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 35]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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