"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _functions = require("../../functions");
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, firstName, lastName, email, meta, tacCompanyId, api_key, IdentityKey, decryptPassowrd, password, passwordHash, alias, verfKey, user, company, admin, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, firstName = _req$body.firstName, lastName = _req$body.lastName, email = _req$body.email, meta = _req$body.meta, tacCompanyId = _req$body.tacCompanyId, api_key = _req$body.api_key, IdentityKey = _req$body.IdentityKey;
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          decryptPassowrd = _crypto["default"].decrypt(meta, _config["default"].adminCentral.crypto_secret);
          if (decryptPassowrd) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Request from invalid source, meta decryption failed.', 409);
        case 9:
          password = decryptPassowrd;
        case 10:
          passwordHash = _bcryptjs["default"].hashSync(password);
          alias = (0, _functions.randomString)(10);
          verfKey = (0, _functions.randomString)(10);
          _context.next = 15;
          return db.Admin.findOne({
            email: email,
            tacIdentityKey: IdentityKey,
            deletedAt: null
          });
        case 15:
          user = _context.sent;
          if (!user) {
            _context.next = 20;
            break;
          }
          _context.next = 19;
          return db.Admin.updateOne({
            email: email,
            deletedAt: null
          }, {
            $set: {
              tacIdentityKey: IdentityKey
            }
          });
        case 19:
          throw new RequestError('Email already exists.', 403);
        case 20:
          _context.next = 22;
          return db.Company.findOne({
            tacCompanyId: tacCompanyId
          });
        case 22:
          company = _context.sent;
          if (company) {
            _context.next = 41;
            break;
          }
          _context.next = 26;
          return db.Company.create({
            alias: alias,
            tacCompanyId: tacCompanyId
          });
        case 26:
          company = _context.sent;
          _context.next = 29;
          return db.MetaData.create({
            companyId: company._id,
            name: 'userLimit',
            value: "10"
          });
        case 29:
          _context.next = 31;
          return db.MetaData.create({
            companyId: company._id,
            name: 'domainLimit',
            value: "1"
          });
        case 31:
          _context.next = 33;
          return db.MetaData.create({
            companyId: company._id,
            name: 'expiredAt',
            value: new Date(new Date(company.createdAt).setDate(new Date(company.createdAt).getDate() + 14))
          });
        case 33:
          _context.next = 35;
          return db.MetaData.create({
            companyId: company._id,
            name: 'tsatUrl',
            value: 'https://tsat.threatcop.com'
          });
        case 35:
          _context.next = 37;
          return db.MetaData.create({
            companyId: company._id,
            name: 'isTsat',
            value: "false"
          });
        case 37:
          _context.next = 39;
          return db.MetaData.create({
            companyId: company._id,
            name: 'mailSmtp',
            value: false
          });
        case 39:
          _context.next = 41;
          return db.MetaData.create({
            companyId: company._id,
            name: 'userLimitMessenger',
            value: '0'
          });
        case 41:
          _context.next = 43;
          return db.Admin.create({
            firstName: firstName,
            lastName: lastName,
            email: email,
            password: passwordHash,
            companyId: company._id,
            verfKey: verfKey,
            tacIdentityKey: IdentityKey,
            isActive: true,
            isVerify: true
          });
        case 43:
          admin = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: "true",
            message: "user created in TPIR",
            response: email
          }));
        case 47:
          _context.prev = 47;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 54:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 47]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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