"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, _req$body, userId, companyId, api_key, isEmployeeExists, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, userId = _req$body.userId, companyId = _req$body.companyId;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 5:
          _context.next = 7;
          return db.Employee.findOne({
            _id: userId,
            companyId: companyId
          });
        case 7:
          isEmployeeExists = _context.sent;
          if (isEmployeeExists) {
            _context.next = 10;
            break;
          }
          throw new RequestError("User doesn't exists, hence can't be deleted", 404);
        case 10:
          _context.next = 12;
          return db.Employee.deleteOne({
            id: userId,
            companyId: companyId
          });
        case 12:
          _context.next = 14;
          return db.EmployeeRole.deleteOne({
            employeeId: userId,
            companyId: companyId
          });
        case 14:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "User deleted successfully."
          }));
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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