"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, _req$body, roleId, companyId, api_key, isRoleExists, employeeRoles, _iterator, _step, employeeRole, newValueArr, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, roleId = _req$body.roleId, companyId = _req$body.companyId;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 5:
          _context.next = 7;
          return db.Role.findOne({
            _id: roleId,
            deletedAt: null
          });
        case 7:
          isRoleExists = _context.sent;
          if (!(isRoleExists && isRoleExists.roleType == 'Default')) {
            _context.next = 10;
            break;
          }
          throw new RequestError("Default role can't be deleted!", 404);
        case 10:
          if (isRoleExists) {
            _context.next = 12;
            break;
          }
          throw new RequestError("Role doesn't exists, hence can't be deleted", 404);
        case 12:
          if (!(isRoleExists && isRoleExists.roleType == "Default")) {
            _context.next = 14;
            break;
          }
          throw new RequestError("Default Roles cannot be deleted!", 403);
        case 14:
          _context.next = 16;
          return db.EmployeeRole.find({
            companyId: companyId
          });
        case 16:
          employeeRoles = _context.sent;
          _iterator = _createForOfIteratorHelper(employeeRoles);
          _context.prev = 18;
          _iterator.s();
        case 20:
          if ((_step = _iterator.n()).done) {
            _context.next = 28;
            break;
          }
          employeeRole = _step.value;
          if (!(employeeRole && employeeRole.roleIds && employeeRole.roleIds.length)) {
            _context.next = 26;
            break;
          }
          newValueArr = employeeRole.roleIds.filter(function (val) {
            return val !== isRoleExists._id;
          });
          _context.next = 26;
          return db.EmployeeRole.updateOne({
            _id: employeeRole._id
          }, {
            $set: {
              roleIds: newValueArr
            }
          });
        case 26:
          _context.next = 20;
          break;
        case 28:
          _context.next = 33;
          break;
        case 30:
          _context.prev = 30;
          _context.t0 = _context["catch"](18);
          _iterator.e(_context.t0);
        case 33:
          _context.prev = 33;
          _iterator.f();
          return _context.finish(33);
        case 36:
          _context.next = 38;
          return db.Role.deleteOne({
            _id: isRoleExists._id
          });
        case 38:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Role deleted successfully."
          }));
        case 41:
          _context.prev = 41;
          _context.t1 = _context["catch"](0);
          statusCode = _context.t1.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t1);
          responseMessage = isClientError ? _context.t1.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t1.code || 'UNEXPECTED_ERROR',
              description: _context.t1.description || null
            } : undefined
          });
        case 48:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 41], [18, 30, 33, 36]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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