"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, api_key, _req$body, roleId, roleName, _req$body$description, description, policyIds, companyId, fetchRole, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 4:
          _req$body = req.body, roleId = _req$body.roleId, roleName = _req$body.roleName, _req$body$description = _req$body.description, description = _req$body$description === void 0 ? "" : _req$body$description, policyIds = _req$body.policyIds, companyId = _req$body.companyId;
          if (!(!roleName || !Array.isArray(policyIds))) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Invalid Request', 400);
        case 7:
          _context.next = 9;
          return db.Role.findOne({
            _id: roleId,
            companyId: companyId
          });
        case 9:
          fetchRole = _context.sent;
          if (fetchRole) {
            _context.next = 12;
            break;
          }
          throw new RequestError("Invalid Role ID or Company ID mismatch", 400);
        case 12:
          _context.next = 14;
          return db.Role.updateOne({
            _id: roleId,
            companyId: companyId
          }, {
            $set: {
              name: roleName,
              description: description,
              policyIds: policyIds
            }
          });
        case 14:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "".concat(roleName, " updated successfully.")
          }));
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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