"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, domainName, api_key, admins, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, domainName = _req$body.domainName, api_key = _req$body.api_key;
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          _context.next = 6;
          return db.Admin.find({
            email: {
              $regex: new RegExp("@".concat(domainName, "$"), 'i')
            },
            deletedAt: null
          }, 'email');
        case 6:
          admins = _context.sent;
          res.status(200).json({
            "success": true,
            "message": "All admins",
            "response": {
              olAccountExist: admins.length > 0 ? true : false,
              admins: admins
            }
          });
          _context.next = 17;
          break;
        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 17:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 10]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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