"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _req$body, companyId, api_key, employees, transformedEmployee, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _req$body = req.body, companyId = _req$body.companyId, api_key = _req$body.api_key;
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context2.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          _context2.next = 6;
          return db.Employee.find({
            companyId: companyId,
            deletedAt: null
          }, {
            '_id': 1,
            'companyId': 1,
            'firstName': 1,
            'lastName': 1,
            'email': 1
          });
        case 6:
          employees = _context2.sent;
          _context2.next = 9;
          return Promise.all(employees.map( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(employee) {
              var employeeRoles, roleNames, roles;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return db.EmployeeRole.findOne({
                      employeeId: employee._id,
                      companyId: employee.companyId
                    }).lean();
                  case 2:
                    employeeRoles = _context.sent;
                    roleNames = [];
                    if (!(employeeRoles && employeeRoles.roleIds && employeeRoles.roleIds.length > 0)) {
                      _context.next = 9;
                      break;
                    }
                    _context.next = 7;
                    return db.Role.find({
                      _id: {
                        $in: employeeRoles.roleIds
                      }
                    }, {
                      roleName: 1
                    }).lean();
                  case 7:
                    roles = _context.sent;
                    roleNames = roles.map(function (role) {
                      return role.roleName;
                    });
                  case 9:
                    return _context.abrupt("return", {
                      localMongoUserId: employee._id,
                      localCompanyId: employee.companyId,
                      firstName: employee.firstName,
                      lastName: employee.lastName,
                      email: employee.email,
                      roles: roleNames
                    });
                  case 10:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }()));
        case 9:
          transformedEmployee = _context2.sent;
          return _context2.abrupt("return", res.status(201).json({
            success: true,
            message: "all-users-tpir",
            response: {
              users: transformedEmployee
            }
          }));
        case 13:
          _context2.prev = 13;
          _context2.t0 = _context2["catch"](0);
          statusCode = _context2.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context2.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context2.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context2.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context2.t0.description || null // Optional additional info
            } : undefined
          });
        case 20:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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