"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _axios = _interopRequireDefault(require("axios"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _apiResponse$data, _apiResponse$data$res, _apiResponse$data2, _apiResponse$data2$re, companyId, company, groupsFromDb, groupMap, _iterator, _step, group, userCount, apiResponse, apiGroups, groupIds, showRetry, _iterator2, _step2, apiGroup, groupIdentityKey, apiUserCount, lastSyncId, dbGroup, isMismatch, _group, allUsersGroup, removedGroups, removedGroupIds, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Company.findOne({
            _id: companyId,
            deletedAt: null
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError("Company not found", 404);
        case 7:
          if (!(company.isTaConnectionInProgess || !company.isTacEnabled)) {
            _context.next = 9;
            break;
          }
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "TA Connection in progress or tac not enabled!"
          }));
        case 9:
          _context.next = 11;
          return db.Group.find({
            companyId: companyId,
            isDefaultGroup: false,
            deletedAt: null
          }).lean();
        case 11:
          groupsFromDb = _context.sent;
          groupMap = {};
          _iterator = _createForOfIteratorHelper(groupsFromDb);
          _context.prev = 14;
          _iterator.s();
        case 16:
          if ((_step = _iterator.n()).done) {
            _context.next = 24;
            break;
          }
          group = _step.value;
          _context.next = 20;
          return db.User.countDocuments({
            groups: {
              $in: [group._id]
            },
            deletedAt: null
          });
        case 20:
          userCount = _context.sent;
          groupMap[group.tacIdentityKey] = _objectSpread(_objectSpread({}, group), {}, {
            userCount: userCount
          });
        case 22:
          _context.next = 16;
          break;
        case 24:
          _context.next = 29;
          break;
        case 26:
          _context.prev = 26;
          _context.t0 = _context["catch"](14);
          _iterator.e(_context.t0);
        case 29:
          _context.prev = 29;
          _iterator.f();
          return _context.finish(29);
        case 32:
          _context.next = 34;
          return _axios["default"].get("".concat(process.env.TAC_URL, "/api/sync-services/common/fetch-group-user-count"), _objectSpread({
            headers: {
              'Content-Type': 'application/json',
              'Authorization': "Bearer ".concat(company.tacLicenseKey)
            }
          }, config.proxy.enableForTA && {
            httpsAgent: config.proxy.proxyAgent,
            httpAgent: config.proxy.proxyAgent
          }));
        case 34:
          apiResponse = _context.sent;
          apiGroups = apiResponse === null || apiResponse === void 0 ? void 0 : (_apiResponse$data = apiResponse.data) === null || _apiResponse$data === void 0 ? void 0 : (_apiResponse$data$res = _apiResponse$data.response) === null || _apiResponse$data$res === void 0 ? void 0 : _apiResponse$data$res.groupUserCount;
          console.log({
            resultTACCCC: apiResponse.data
          });
          groupIds = [];
          showRetry = apiResponse === null || apiResponse === void 0 ? void 0 : (_apiResponse$data2 = apiResponse.data) === null || _apiResponse$data2 === void 0 ? void 0 : (_apiResponse$data2$re = _apiResponse$data2.response) === null || _apiResponse$data2$re === void 0 ? void 0 : _apiResponse$data2$re.showRetry;
          _iterator2 = _createForOfIteratorHelper(apiGroups);
          _context.prev = 40;
          _iterator2.s();
        case 42:
          if ((_step2 = _iterator2.n()).done) {
            _context.next = 65;
            break;
          }
          apiGroup = _step2.value;
          groupIdentityKey = apiGroup.groupIdentityKey, apiUserCount = apiGroup.userCount, lastSyncId = apiGroup.lastSyncId;
          dbGroup = groupMap[groupIdentityKey];
          console.log({
            dbGroup: dbGroup,
            apiGroup: apiGroup,
            condition: {
              1: (dbGroup === null || dbGroup === void 0 ? void 0 : dbGroup.lastSyncId) !== lastSyncId,
              2: (dbGroup === null || dbGroup === void 0 ? void 0 : dbGroup.userCount) !== apiUserCount
            }
          });
          if (!dbGroup) {
            _context.next = 59;
            break;
          }
          isMismatch = dbGroup.lastSyncId !== lastSyncId || dbGroup.userCount !== apiUserCount;
          if (!isMismatch) {
            _context.next = 54;
            break;
          }
          _context.next = 52;
          return db.Group.updateOne({
            _id: dbGroup._id
          }, {
            lastSyncIdMismatch: true,
            groupName: apiGroup === null || apiGroup === void 0 ? void 0 : apiGroup.groupName
          });
        case 52:
          _context.next = 56;
          break;
        case 54:
          _context.next = 56;
          return db.Group.updateOne({
            _id: dbGroup._id
          }, {
            lastSyncIdMismatch: false,
            groupName: apiGroup === null || apiGroup === void 0 ? void 0 : apiGroup.groupName
          });
        case 56:
          groupIds.push(dbGroup._id);
          _context.next = 63;
          break;
        case 59:
          _context.next = 61;
          return db.Group.create({
            groupName: apiGroup === null || apiGroup === void 0 ? void 0 : apiGroup.groupName,
            tacIdentityKey: apiGroup === null || apiGroup === void 0 ? void 0 : apiGroup.groupIdentityKey,
            type: "Admin",
            companyId: companyId,
            lastSyncId: null,
            lastSyncIdMismatch: true
          });
        case 61:
          _group = _context.sent;
          groupIds.push(_group._id);
        case 63:
          _context.next = 42;
          break;
        case 65:
          _context.next = 70;
          break;
        case 67:
          _context.prev = 67;
          _context.t1 = _context["catch"](40);
          _iterator2.e(_context.t1);
        case 70:
          _context.prev = 70;
          _iterator2.f();
          return _context.finish(70);
        case 73:
          _context.next = 75;
          return db.Group.findOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          });
        case 75:
          allUsersGroup = _context.sent;
          _context.next = 78;
          return db.Group.find({
            _id: {
              $nin: groupIds
            },
            type: "Admin",
            companyId: companyId,
            isDefaultGroup: false
          }, {
            _id: 1
          });
        case 78:
          removedGroups = _context.sent;
          removedGroupIds = removedGroups.map(function (g) {
            return g._id;
          });
          _context.next = 82;
          return db.Group.deleteMany({
            _id: {
              $in: removedGroupIds
            }
          });
        case 82:
          _context.next = 84;
          return db.User.updateMany({
            groups: {
              $in: removedGroupIds
            }
          }, {
            $pull: {
              groups: {
                $in: removedGroupIds
              }
            }
          });
        case 84:
          console.log("DELTETETETET KRA KRA", removedGroupIds);

          //removing users with only all-users-tpir group and currentGroup
          _context.next = 87;
          return db.User.deleteMany({
            groups: {
              $all: [allUsersGroup._id],
              $size: 1
            },
            companyId: companyId
          });
        case 87:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            showRetry: showRetry
          }));
        case 90:
          _context.prev = 90;
          _context.t2 = _context["catch"](0);
          statusCode = _context.t2.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t2);
          responseMessage = isClientError ? _context.t2.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t2.code || 'UNEXPECTED_ERROR',
              description: _context.t2.description || null
            } : undefined
          });
        case 97:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 90], [14, 26, 29, 32], [40, 67, 70, 73]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImNvbXBhbnlJZCIsInVzZXIiLCJkYiIsIkNvbXBhbnkiLCJmaW5kT25lIiwiX2lkIiwiZGVsZXRlZEF0IiwiY29tcGFueSIsIlJlcXVlc3RFcnJvciIsImlzVGFDb25uZWN0aW9uSW5Qcm9nZXNzIiwiaXNUYWNFbmFibGVkIiwic3RhdHVzIiwic2VuZCIsInN1Y2Nlc3MiLCJtZXNzYWdlIiwiR3JvdXAiLCJmaW5kIiwiaXNEZWZhdWx0R3JvdXAiLCJsZWFuIiwiZ3JvdXBzRnJvbURiIiwiZ3JvdXBNYXAiLCJncm91cCIsIlVzZXIiLCJjb3VudERvY3VtZW50cyIsImdyb3VwcyIsIiRpbiIsInVzZXJDb3VudCIsInRhY0lkZW50aXR5S2V5IiwiYXhpb3MiLCJnZXQiLCJwcm9jZXNzIiwiZW52IiwiVEFDX1VSTCIsImhlYWRlcnMiLCJ0YWNMaWNlbnNlS2V5IiwiY29uZmlnIiwicHJveHkiLCJlbmFibGVGb3JUQSIsImh0dHBzQWdlbnQiLCJwcm94eUFnZW50IiwiaHR0cEFnZW50IiwiYXBpUmVzcG9uc2UiLCJhcGlHcm91cHMiLCJkYXRhIiwicmVzcG9uc2UiLCJncm91cFVzZXJDb3VudCIsImNvbnNvbGUiLCJsb2ciLCJyZXN1bHRUQUNDQ0MiLCJncm91cElkcyIsInNob3dSZXRyeSIsImFwaUdyb3VwIiwiZ3JvdXBJZGVudGl0eUtleSIsImFwaVVzZXJDb3VudCIsImxhc3RTeW5jSWQiLCJkYkdyb3VwIiwiY29uZGl0aW9uIiwiaXNNaXNtYXRjaCIsInVwZGF0ZU9uZSIsImxhc3RTeW5jSWRNaXNtYXRjaCIsImdyb3VwTmFtZSIsInB1c2giLCJjcmVhdGUiLCJ0eXBlIiwiYWxsVXNlcnNHcm91cCIsIiRuaW4iLCJyZW1vdmVkR3JvdXBzIiwicmVtb3ZlZEdyb3VwSWRzIiwibWFwIiwiZyIsImRlbGV0ZU1hbnkiLCJ1cGRhdGVNYW55IiwiJHB1bGwiLCIkYWxsIiwiJHNpemUiLCJzdGF0dXNDb2RlIiwiaXNDbGllbnRFcnJvciIsImVycm9yIiwicmVzcG9uc2VNZXNzYWdlIiwianNvbiIsImNvZGUiLCJkZXNjcmlwdGlvbiIsInVuZGVmaW5lZCIsImFwaVJvdXRlciIsImV4cHJlc3MiLCJSb3V0ZXIiLCJyb3V0ZSIsImp3dFN0cmF0ZWd5Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9hZG1pbkNlbnRyYWwvZmV0Y2gtZ3JvdXAtdXNlci1jb3VudC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZXhwcmVzcyBmcm9tICdleHByZXNzJztcbmltcG9ydCB7IGp3dFN0cmF0ZWd5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc3RyYXRlZ3knXG5pbXBvcnQgYXhpb3MgZnJvbSAnYXhpb3MnXG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5e1xuICAgICAgICBjb25zdCB7IGNvbXBhbnlJZCB9ID0gcmVxLnVzZXJcblxuICAgICAgICBjb25zdCBjb21wYW55ID0gYXdhaXQgZGIuQ29tcGFueS5maW5kT25lKHtfaWQ6IGNvbXBhbnlJZCwgZGVsZXRlZEF0OiBudWxsfSlcbiAgICAgICAgaWYoIWNvbXBhbnkpIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoXCJDb21wYW55IG5vdCBmb3VuZFwiLDQwNClcbiAgICAgICAgXG4gICAgICAgIGlmKGNvbXBhbnkuaXNUYUNvbm5lY3Rpb25JblByb2dlc3MgfHwgIWNvbXBhbnkuaXNUYWNFbmFibGVkKSByZXR1cm4gcmVzLnN0YXR1cygyMDApLnNlbmQoe3N1Y2Nlc3M6IHRydWUsIG1lc3NhZ2U6XCJUQSBDb25uZWN0aW9uIGluIHByb2dyZXNzIG9yIHRhYyBub3QgZW5hYmxlZCFcIn0pXG4gICAgICAgICAgICBcbiAgICAgICAgY29uc3QgZ3JvdXBzRnJvbURiID0gYXdhaXQgZGIuR3JvdXAuZmluZCh7IGNvbXBhbnlJZCwgaXNEZWZhdWx0R3JvdXA6IGZhbHNlLCBkZWxldGVkQXQ6IG51bGwgfSkubGVhbigpO1xuICAgICAgICBjb25zdCBncm91cE1hcCA9IHt9O1xuXG4gICAgICAgIGZvciAoY29uc3QgZ3JvdXAgb2YgZ3JvdXBzRnJvbURiKSB7XG4gICAgICAgICAgICBjb25zdCB1c2VyQ291bnQgPSBhd2FpdCBkYi5Vc2VyLmNvdW50RG9jdW1lbnRzKHsgZ3JvdXBzOiB7JGluOiBbZ3JvdXAuX2lkXX0sIGRlbGV0ZWRBdDogbnVsbCB9KTtcblxuICAgICAgICAgICAgZ3JvdXBNYXBbZ3JvdXAudGFjSWRlbnRpdHlLZXldID0ge1xuICAgICAgICAgICAgICAgIC4uLmdyb3VwLFxuICAgICAgICAgICAgICAgIHVzZXJDb3VudCwgXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG5cblxuICAgICAgICBsZXQgYXBpUmVzcG9uc2UgPWF3YWl0IGF4aW9zLmdldChgJHtwcm9jZXNzLmVudi5UQUNfVVJMfS9hcGkvc3luYy1zZXJ2aWNlcy9jb21tb24vZmV0Y2gtZ3JvdXAtdXNlci1jb3VudGAsXG4gICAgICAgIHtcbiAgICAgICAgICAgIGhlYWRlcnM6IHtcbiAgICAgICAgICAgICAgICAnQ29udGVudC1UeXBlJzogJ2FwcGxpY2F0aW9uL2pzb24nLFxuICAgICAgICAgICAgICAgICdBdXRob3JpemF0aW9uJzogYEJlYXJlciAke2NvbXBhbnkudGFjTGljZW5zZUtleX1gXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgLi4uKGNvbmZpZy5wcm94eS5lbmFibGVGb3JUQSAmJiB7IGh0dHBzQWdlbnQ6IGNvbmZpZy5wcm94eS5wcm94eUFnZW50LCBodHRwQWdlbnQ6IGNvbmZpZy5wcm94eS5wcm94eUFnZW50IH0pXG4gICAgICAgIH1cbiAgICAgICAgKVxuXG4gICAgICAgIGNvbnN0IGFwaUdyb3VwcyA9IGFwaVJlc3BvbnNlPy5kYXRhPy5yZXNwb25zZT8uZ3JvdXBVc2VyQ291bnQ7XG4gICAgICAgIGNvbnNvbGUubG9nKHtyZXN1bHRUQUNDQ0M6IGFwaVJlc3BvbnNlLmRhdGF9KVxuXG4gICAgICAgIGxldCBncm91cElkcyA9IFtdXG4gICAgICAgIGxldCBzaG93UmV0cnkgPSBhcGlSZXNwb25zZT8uZGF0YT8ucmVzcG9uc2U/LnNob3dSZXRyeVxuICAgICAgICBmb3IgKGNvbnN0IGFwaUdyb3VwIG9mIGFwaUdyb3Vwcykge1xuICAgICAgICAgICAgY29uc3QgeyBncm91cElkZW50aXR5S2V5LCB1c2VyQ291bnQ6IGFwaVVzZXJDb3VudCwgbGFzdFN5bmNJZCB9ID0gYXBpR3JvdXA7XG5cbiAgICAgICAgICAgIGNvbnN0IGRiR3JvdXAgPSBncm91cE1hcFtncm91cElkZW50aXR5S2V5XTtcbiAgICAgICAgICAgIGNvbnNvbGUubG9nKHtkYkdyb3VwLCBhcGlHcm91cCwgY29uZGl0aW9uOnsxOiBkYkdyb3VwPy5sYXN0U3luY0lkICE9PSBsYXN0U3luY0lkLCAyOmRiR3JvdXA/LnVzZXJDb3VudCAhPT0gYXBpVXNlckNvdW50fX0pXG5cbiAgICAgICAgICAgIGlmIChkYkdyb3VwKSB7XG4gICAgICAgICAgICAgICAgY29uc3QgaXNNaXNtYXRjaCA9IGRiR3JvdXAubGFzdFN5bmNJZCAhPT0gbGFzdFN5bmNJZCB8fCBkYkdyb3VwLnVzZXJDb3VudCAhPT0gYXBpVXNlckNvdW50O1xuXG4gICAgICAgICAgICAgICAgaWYgKGlzTWlzbWF0Y2gpIHtcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgZGIuR3JvdXAudXBkYXRlT25lKFxuICAgICAgICAgICAgICAgICAgICAgICAgeyBfaWQ6IGRiR3JvdXAuX2lkIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICB7IGxhc3RTeW5jSWRNaXNtYXRjaDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgZ3JvdXBOYW1lOiBhcGlHcm91cD8uZ3JvdXBOYW1lLFxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNle1xuICAgICAgICAgICAgICAgICAgICBhd2FpdCBkYi5Hcm91cC51cGRhdGVPbmUoXG4gICAgICAgICAgICAgICAgICAgICAgICB7IF9pZDogZGJHcm91cC5faWQgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHsgbGFzdFN5bmNJZE1pc21hdGNoOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgZ3JvdXBOYW1lOiBhcGlHcm91cD8uZ3JvdXBOYW1lLFxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBncm91cElkcy5wdXNoKGRiR3JvdXAuX2lkKVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZWxzZXtcbiAgICAgICAgICAgICAgICBsZXQgZ3JvdXAgPSBhd2FpdCBkYi5Hcm91cC5jcmVhdGUoe1xuICAgICAgICAgICAgICAgICAgICBncm91cE5hbWU6IGFwaUdyb3VwPy5ncm91cE5hbWUsXG4gICAgICAgICAgICAgICAgICAgIHRhY0lkZW50aXR5S2V5OiBhcGlHcm91cD8uZ3JvdXBJZGVudGl0eUtleSxcbiAgICAgICAgICAgICAgICAgICAgdHlwZTogXCJBZG1pblwiLFxuICAgICAgICAgICAgICAgICAgICBjb21wYW55SWQsXG4gICAgICAgICAgICAgICAgICAgIGxhc3RTeW5jSWQ6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIGxhc3RTeW5jSWRNaXNtYXRjaDogdHJ1ZSxcbiAgICAgICAgICAgICAgICB9KVxuXG4gICAgICAgICAgICAgICAgZ3JvdXBJZHMucHVzaChncm91cC5faWQpXG4gICAgICAgICAgICB9XG5cbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IGFsbFVzZXJzR3JvdXAgPSBhd2FpdCBkYi5Hcm91cC5maW5kT25lKHtjb21wYW55SWQsIGdyb3VwTmFtZTpcImFsbC11c2Vycy10cGlyXCIsIGlzRGVmYXVsdEdyb3VwOiB0cnVlLCBkZWxldGVkQXQ6IG51bGx9KVxuXG4gICAgICAgIC8vUmVtb3ZpbmcgYWRtaW4gZ3JvdXBzIG5vdCBwcmVzZW50IGluIFRBXG4gICAgICAgIGNvbnN0IHJlbW92ZWRHcm91cHMgPSBhd2FpdCBkYi5Hcm91cC5maW5kKFxuICAgICAgICAgICAgeyBfaWQ6IHsgJG5pbjogZ3JvdXBJZHMgfSwgdHlwZTogXCJBZG1pblwiLCBjb21wYW55SWQsIGlzRGVmYXVsdEdyb3VwOiBmYWxzZSB9LFxuICAgICAgICAgICAgeyBfaWQ6IDEgfVxuICAgICAgICApO1xuXG4gICAgICAgIGNvbnN0IHJlbW92ZWRHcm91cElkcyA9IHJlbW92ZWRHcm91cHMubWFwKGcgPT4gZy5faWQpO1xuXG4gICAgICAgIGF3YWl0IGRiLkdyb3VwLmRlbGV0ZU1hbnkoeyBfaWQ6IHsgJGluOiByZW1vdmVkR3JvdXBJZHMgfSB9KTtcblxuICAgICAgICAvL0Rpc2Fzc29jaWF0aW5nIHRoZSByZW1vdmVkIGdyb3VwcyBmcm9tIHVzZXJzXG4gICAgICAgIGF3YWl0IGRiLlVzZXIudXBkYXRlTWFueShcbiAgICAgICAgICAgIHsgZ3JvdXBzOiB7ICRpbjogcmVtb3ZlZEdyb3VwSWRzIH0gfSxcbiAgICAgICAgICAgIHsgJHB1bGw6IHsgZ3JvdXBzOiB7ICRpbjogcmVtb3ZlZEdyb3VwSWRzIH0gfSB9XG4gICAgICAgICk7XG5cbiAgICAgICAgY29uc29sZS5sb2coXCJERUxURVRFVEVURVQgS1JBIEtSQVwiLHJlbW92ZWRHcm91cElkcylcblxuICAgICAgICAvL3JlbW92aW5nIHVzZXJzIHdpdGggb25seSBhbGwtdXNlcnMtdHBpciBncm91cCBhbmQgY3VycmVudEdyb3VwXG4gICAgICAgIGF3YWl0IGRiLlVzZXIuZGVsZXRlTWFueSh7XG4gICAgICAgICAgICBncm91cHM6IHsgJGFsbDogW2FsbFVzZXJzR3JvdXAuX2lkXSwgJHNpemU6IDEgfSxcbiAgICAgICAgICAgIGNvbXBhbnlJZFxuICAgICAgICB9KTtcblxuXG4gICAgICAgIHJldHVybiByZXMuc3RhdHVzKDIwMCkuc2VuZCh7XG4gICAgICAgICAgICBzdWNjZXNzOiB0cnVlLFxuICAgICAgICAgICAgc2hvd1JldHJ5XG4gICAgICAgIH0pXG4gICAgICB9Y2F0Y2goZXJyb3Ipe1xuICAgICAgICBjb25zdCBzdGF0dXNDb2RlID0gZXJyb3Iuc3RhdHVzIHx8IDUwMDtcbiAgICAgICAgY29uc3QgaXNDbGllbnRFcnJvciA9IHN0YXR1c0NvZGUgPj0gNDAwICYmIHN0YXR1c0NvZGUgPCA1MDA7XG4gICAgICAgIGNvbnNvbGUuZXJyb3IoJ0FQSSBFcnJvcjonLCBlcnJvcik7XG4gIFxuICAgICAgICBjb25zdCByZXNwb25zZU1lc3NhZ2UgPSBpc0NsaWVudEVycm9yXG4gICAgICAgICAgICA/IGVycm9yLm1lc3NhZ2UgfHwgJ1RoZSByZXF1ZXN0IGNvdWxkIG5vdCBiZSBwcm9jZXNzZWQuJ1xuICAgICAgICAgICAgOiAnQW4gaW50ZXJuYWwgc2VydmVyIGVycm9yIG9jY3VycmVkLic7XG4gIFxuICAgICAgICByZXMuc3RhdHVzKHN0YXR1c0NvZGUpLmpzb24oe1xuICAgICAgICAgICAgc3VjY2VzczogZmFsc2UsXG4gICAgICAgICAgICBtZXNzYWdlOiByZXNwb25zZU1lc3NhZ2UsXG4gICAgICAgICAgICBlcnJvcjogaXNDbGllbnRFcnJvciA/IHsgY29kZTogZXJyb3IuY29kZSB8fCAnVU5FWFBFQ1RFRF9FUlJPUicsIGRlc2NyaXB0aW9uOiBlcnJvci5kZXNjcmlwdGlvbiB8fCBudWxsIH0gOiB1bmRlZmluZWQsXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5nZXQoIGp3dFN0cmF0ZWd5LCBjb250cm9sbGVyKTtcbmV4cG9ydCBkZWZhdWx0IGFwaVJvdXRlcjsiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFBeUI7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUV6QixJQUFJQSxVQUFVO0VBQUEseUZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUV0QkMsU0FBUyxHQUFLSCxHQUFHLENBQUNJLElBQUksQ0FBdEJELFNBQVM7VUFBQTtVQUFBLE9BRUtFLEVBQUUsQ0FBQ0MsT0FBTyxDQUFDQyxPQUFPLENBQUM7WUFBQ0MsR0FBRyxFQUFFTCxTQUFTO1lBQUVNLFNBQVMsRUFBRTtVQUFJLENBQUMsQ0FBQztRQUFBO1VBQXJFQyxPQUFPO1VBQUEsSUFDVEEsT0FBTztZQUFBO1lBQUE7VUFBQTtVQUFBLE1BQVEsSUFBSUMsWUFBWSxDQUFDLG1CQUFtQixFQUFDLEdBQUcsQ0FBQztRQUFBO1VBQUEsTUFFekRELE9BQU8sQ0FBQ0UsdUJBQXVCLElBQUksQ0FBQ0YsT0FBTyxDQUFDRyxZQUFZO1lBQUE7WUFBQTtVQUFBO1VBQUEsaUNBQVNaLEdBQUcsQ0FBQ2EsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUM7WUFBQ0MsT0FBTyxFQUFFLElBQUk7WUFBRUMsT0FBTyxFQUFDO1VBQStDLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUV2SVosRUFBRSxDQUFDYSxLQUFLLENBQUNDLElBQUksQ0FBQztZQUFFaEIsU0FBUyxFQUFUQSxTQUFTO1lBQUVpQixjQUFjLEVBQUUsS0FBSztZQUFFWCxTQUFTLEVBQUU7VUFBSyxDQUFDLENBQUMsQ0FBQ1ksSUFBSSxFQUFFO1FBQUE7VUFBaEdDLFlBQVk7VUFDWkMsUUFBUSxHQUFHLENBQUMsQ0FBQztVQUFBLHVDQUVDRCxZQUFZO1VBQUE7VUFBQTtRQUFBO1VBQUE7WUFBQTtZQUFBO1VBQUE7VUFBckJFLEtBQUs7VUFBQTtVQUFBLE9BQ1luQixFQUFFLENBQUNvQixJQUFJLENBQUNDLGNBQWMsQ0FBQztZQUFFQyxNQUFNLEVBQUU7Y0FBQ0MsR0FBRyxFQUFFLENBQUNKLEtBQUssQ0FBQ2hCLEdBQUc7WUFBQyxDQUFDO1lBQUVDLFNBQVMsRUFBRTtVQUFLLENBQUMsQ0FBQztRQUFBO1VBQXpGb0IsU0FBUztVQUVmTixRQUFRLENBQUNDLEtBQUssQ0FBQ00sY0FBYyxDQUFDLG1DQUN2Qk4sS0FBSztZQUNSSyxTQUFTLEVBQVRBO1VBQVMsRUFDWjtRQUFDO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUEsT0FJaUJFLGlCQUFLLENBQUNDLEdBQUcsV0FBSUMsT0FBTyxDQUFDQyxHQUFHLENBQUNDLE9BQU87WUFFbkRDLE9BQU8sRUFBRTtjQUNMLGNBQWMsRUFBRSxrQkFBa0I7Y0FDbEMsZUFBZSxtQkFBWTFCLE9BQU8sQ0FBQzJCLGFBQWE7WUFDcEQ7VUFBQyxHQUNHQyxNQUFNLENBQUNDLEtBQUssQ0FBQ0MsV0FBVyxJQUFJO1lBQUVDLFVBQVUsRUFBRUgsTUFBTSxDQUFDQyxLQUFLLENBQUNHLFVBQVU7WUFBRUMsU0FBUyxFQUFFTCxNQUFNLENBQUNDLEtBQUssQ0FBQ0c7VUFBVyxDQUFDLEVBRTlHO1FBQUE7VUFSR0UsV0FBVztVQVVUQyxTQUFTLEdBQUdELFdBQVcsYUFBWEEsV0FBVyw0Q0FBWEEsV0FBVyxDQUFFRSxJQUFJLCtFQUFqQixrQkFBbUJDLFFBQVEsMERBQTNCLHNCQUE2QkMsY0FBYztVQUM3REMsT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ0MsWUFBWSxFQUFFUCxXQUFXLENBQUNFO1VBQUksQ0FBQyxDQUFDO1VBRXpDTSxRQUFRLEdBQUcsRUFBRTtVQUNiQyxTQUFTLEdBQUdULFdBQVcsYUFBWEEsV0FBVyw2Q0FBWEEsV0FBVyxDQUFFRSxJQUFJLGdGQUFqQixtQkFBbUJDLFFBQVEsMERBQTNCLHNCQUE2Qk0sU0FBUztVQUFBLHdDQUMvQlIsU0FBUztVQUFBO1VBQUE7UUFBQTtVQUFBO1lBQUE7WUFBQTtVQUFBO1VBQXJCUyxRQUFRO1VBQ1BDLGdCQUFnQixHQUEwQ0QsUUFBUSxDQUFsRUMsZ0JBQWdCLEVBQWFDLFlBQVksR0FBaUJGLFFBQVEsQ0FBaER6QixTQUFTLEVBQWdCNEIsVUFBVSxHQUFLSCxRQUFRLENBQXZCRyxVQUFVO1VBRXZEQyxPQUFPLEdBQUduQyxRQUFRLENBQUNnQyxnQkFBZ0IsQ0FBQztVQUMxQ04sT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ1EsT0FBTyxFQUFQQSxPQUFPO1lBQUVKLFFBQVEsRUFBUkEsUUFBUTtZQUFFSyxTQUFTLEVBQUM7Y0FBQyxDQUFDLEVBQUUsQ0FBQUQsT0FBTyxhQUFQQSxPQUFPLHVCQUFQQSxPQUFPLENBQUVELFVBQVUsTUFBS0EsVUFBVTtjQUFFLENBQUMsRUFBQyxDQUFBQyxPQUFPLGFBQVBBLE9BQU8sdUJBQVBBLE9BQU8sQ0FBRTdCLFNBQVMsTUFBSzJCO1lBQVk7VUFBQyxDQUFDLENBQUM7VUFBQSxLQUV0SEUsT0FBTztZQUFBO1lBQUE7VUFBQTtVQUNERSxVQUFVLEdBQUdGLE9BQU8sQ0FBQ0QsVUFBVSxLQUFLQSxVQUFVLElBQUlDLE9BQU8sQ0FBQzdCLFNBQVMsS0FBSzJCLFlBQVk7VUFBQSxLQUV0RkksVUFBVTtZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FDSnZELEVBQUUsQ0FBQ2EsS0FBSyxDQUFDMkMsU0FBUyxDQUNwQjtZQUFFckQsR0FBRyxFQUFFa0QsT0FBTyxDQUFDbEQ7VUFBSSxDQUFDLEVBQ3BCO1lBQUVzRCxrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCQyxTQUFTLEVBQUVULFFBQVEsYUFBUkEsUUFBUSx1QkFBUkEsUUFBUSxDQUFFUztVQUN2QixDQUFDLENBQ0o7UUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUEsT0FHSzFELEVBQUUsQ0FBQ2EsS0FBSyxDQUFDMkMsU0FBUyxDQUNwQjtZQUFFckQsR0FBRyxFQUFFa0QsT0FBTyxDQUFDbEQ7VUFBSSxDQUFDLEVBQ3BCO1lBQUVzRCxrQkFBa0IsRUFBRSxLQUFLO1lBQ3pCQyxTQUFTLEVBQUVULFFBQVEsYUFBUkEsUUFBUSx1QkFBUkEsUUFBUSxDQUFFUztVQUN2QixDQUFDLENBQ0o7UUFBQTtVQUVMWCxRQUFRLENBQUNZLElBQUksQ0FBQ04sT0FBTyxDQUFDbEQsR0FBRyxDQUFDO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQSxPQUdSSCxFQUFFLENBQUNhLEtBQUssQ0FBQytDLE1BQU0sQ0FBQztZQUM5QkYsU0FBUyxFQUFFVCxRQUFRLGFBQVJBLFFBQVEsdUJBQVJBLFFBQVEsQ0FBRVMsU0FBUztZQUM5QmpDLGNBQWMsRUFBRXdCLFFBQVEsYUFBUkEsUUFBUSx1QkFBUkEsUUFBUSxDQUFFQyxnQkFBZ0I7WUFDMUNXLElBQUksRUFBRSxPQUFPO1lBQ2IvRCxTQUFTLEVBQVRBLFNBQVM7WUFDVHNELFVBQVUsRUFBRSxJQUFJO1lBQ2hCSyxrQkFBa0IsRUFBRTtVQUN4QixDQUFDLENBQUM7UUFBQTtVQVBFdEMsTUFBSztVQVNUNEIsUUFBUSxDQUFDWSxJQUFJLENBQUN4QyxNQUFLLENBQUNoQixHQUFHLENBQUM7UUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBLE9BS0pILEVBQUUsQ0FBQ2EsS0FBSyxDQUFDWCxPQUFPLENBQUM7WUFBQ0osU0FBUyxFQUFUQSxTQUFTO1lBQUU0RCxTQUFTLEVBQUMsZ0JBQWdCO1lBQUUzQyxjQUFjLEVBQUUsSUFBSTtZQUFFWCxTQUFTLEVBQUU7VUFBSSxDQUFDLENBQUM7UUFBQTtVQUF0SDBELGFBQWE7VUFBQTtVQUFBLE9BR1M5RCxFQUFFLENBQUNhLEtBQUssQ0FBQ0MsSUFBSSxDQUNyQztZQUFFWCxHQUFHLEVBQUU7Y0FBRTRELElBQUksRUFBRWhCO1lBQVMsQ0FBQztZQUFFYyxJQUFJLEVBQUUsT0FBTztZQUFFL0QsU0FBUyxFQUFUQSxTQUFTO1lBQUVpQixjQUFjLEVBQUU7VUFBTSxDQUFDLEVBQzVFO1lBQUVaLEdBQUcsRUFBRTtVQUFFLENBQUMsQ0FDYjtRQUFBO1VBSEs2RCxhQUFhO1VBS2JDLGVBQWUsR0FBR0QsYUFBYSxDQUFDRSxHQUFHLENBQUMsVUFBQUMsQ0FBQztZQUFBLE9BQUlBLENBQUMsQ0FBQ2hFLEdBQUc7VUFBQSxFQUFDO1VBQUE7VUFBQSxPQUUvQ0gsRUFBRSxDQUFDYSxLQUFLLENBQUN1RCxVQUFVLENBQUM7WUFBRWpFLEdBQUcsRUFBRTtjQUFFb0IsR0FBRyxFQUFFMEM7WUFBZ0I7VUFBRSxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUEsT0FHdERqRSxFQUFFLENBQUNvQixJQUFJLENBQUNpRCxVQUFVLENBQ3BCO1lBQUUvQyxNQUFNLEVBQUU7Y0FBRUMsR0FBRyxFQUFFMEM7WUFBZ0I7VUFBRSxDQUFDLEVBQ3BDO1lBQUVLLEtBQUssRUFBRTtjQUFFaEQsTUFBTSxFQUFFO2dCQUFFQyxHQUFHLEVBQUUwQztjQUFnQjtZQUFFO1VBQUUsQ0FBQyxDQUNsRDtRQUFBO1VBRURyQixPQUFPLENBQUNDLEdBQUcsQ0FBQyxzQkFBc0IsRUFBQ29CLGVBQWUsQ0FBQzs7VUFFbkQ7VUFBQTtVQUFBLE9BQ01qRSxFQUFFLENBQUNvQixJQUFJLENBQUNnRCxVQUFVLENBQUM7WUFDckI5QyxNQUFNLEVBQUU7Y0FBRWlELElBQUksRUFBRSxDQUFDVCxhQUFhLENBQUMzRCxHQUFHLENBQUM7Y0FBRXFFLEtBQUssRUFBRTtZQUFFLENBQUM7WUFDL0MxRSxTQUFTLEVBQVRBO1VBQ0osQ0FBQyxDQUFDO1FBQUE7VUFBQSxpQ0FHS0YsR0FBRyxDQUFDYSxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQztZQUN4QkMsT0FBTyxFQUFFLElBQUk7WUFDYnFDLFNBQVMsRUFBVEE7VUFDSixDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUE7VUFFSXlCLFVBQVUsR0FBRyxZQUFNaEUsTUFBTSxJQUFJLEdBQUc7VUFDaENpRSxhQUFhLEdBQUdELFVBQVUsSUFBSSxHQUFHLElBQUlBLFVBQVUsR0FBRyxHQUFHO1VBQzNEN0IsT0FBTyxDQUFDK0IsS0FBSyxDQUFDLFlBQVksY0FBUTtVQUU1QkMsZUFBZSxHQUFHRixhQUFhLEdBQy9CLFlBQU05RCxPQUFPLElBQUkscUNBQXFDLEdBQ3RELG9DQUFvQztVQUUxQ2hCLEdBQUcsQ0FBQ2EsTUFBTSxDQUFDZ0UsVUFBVSxDQUFDLENBQUNJLElBQUksQ0FBQztZQUN4QmxFLE9BQU8sRUFBRSxLQUFLO1lBQ2RDLE9BQU8sRUFBRWdFLGVBQWU7WUFDeEJELEtBQUssRUFBRUQsYUFBYSxHQUFHO2NBQUVJLElBQUksRUFBRSxZQUFNQSxJQUFJLElBQUksa0JBQWtCO2NBQUVDLFdBQVcsRUFBRSxZQUFNQSxXQUFXLElBQUk7WUFBSyxDQUFDLEdBQUdDO1VBQ2hILENBQUMsQ0FBQztRQUFDO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUVOO0VBQUEsZ0JBN0hEdEYsVUFBVTtJQUFBO0VBQUE7QUFBQSxHQTZIVDtBQUNMLElBQU11RixTQUFTLEdBQUdDLG1CQUFPLENBQUNDLE1BQU0sRUFBRTtBQUNsQ0YsU0FBUyxDQUFDRyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUN6RCxHQUFHLENBQUUwRCxxQkFBVyxFQUFFM0YsVUFBVSxDQUFDO0FBQUMsZUFDcEN1RixTQUFTO0FBQUEifQ==