"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, companyId, tacGroupId, _req$body$limit, limit, _req$body$offset, offset, groupId, api_key, groupMembers, transformedGroupMembers, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, companyId = _req$body.companyId, tacGroupId = _req$body.tacGroupId, _req$body$limit = _req$body.limit, limit = _req$body$limit === void 0 ? 100 : _req$body$limit, _req$body$offset = _req$body.offset, offset = _req$body$offset === void 0 ? 10 : _req$body$offset, groupId = _req$body.groupId, api_key = _req$body.api_key;
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          limit = parseInt(limit, 10) || 100; // Default limit to 100 if undefined or invalid
          offset = parseInt(offset, 10) || 0; // Default offset to 0 if undefined or invalid
          _context.next = 8;
          return db.User.find({
            groups: {
              $in: [groupId]
            }
          }).skip(offset).limit(limit).select('_id name email phoneNumber');
        case 8:
          groupMembers = _context.sent;
          transformedGroupMembers = groupMembers.map(function (member) {
            var _member$name, _member$name2, _member$name3;
            return {
              Member: {
                id: member._id,
                firstName: member === null || member === void 0 ? void 0 : (_member$name = member.name) === null || _member$name === void 0 ? void 0 : _member$name.split(" ")[0],
                lastName: member !== null && member !== void 0 && (_member$name2 = member.name) !== null && _member$name2 !== void 0 && _member$name2.split(" ")[1] ? member === null || member === void 0 ? void 0 : (_member$name3 = member.name) === null || _member$name3 === void 0 ? void 0 : _member$name3.split(" ")[1] : '',
                email: member === null || member === void 0 ? void 0 : member.email,
                phoneNumber: member === null || member === void 0 ? void 0 : member.phoneNumber
              }
            };
          });
          if (!(offset <= 1)) {
            _context.next = 13;
            break;
          }
          _context.next = 13;
          return db.Group.updateOne({
            groupId: groupId
          }, {
            $set: {
              tacGroupId: tacGroupId,
              type: "Admin"
            }
          });
        case 13:
          return _context.abrupt("return", res.status(201).json({
            success: true,
            message: "all-users-tpir",
            response: transformedGroupMembers
          }));
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 23:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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