"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _crypto = _interopRequireDefault(require("../../crypto"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, api_key, _req$query$limit, limit, _req$query$offset, offset, _req$query$search, search, _req$query$roleId, roleId, companyId, condition, regex, _employees, _employeeIds, _employeeRoles, _details, _iterator, _step, val, obj, _iterator2, _step2, _roleId, roleDetails, _count, employees, employeeIds, employeeRoles, details, _iterator3, _step3, _val, _obj, _iterator4, _step4, _roleId2, _roleDetails, count, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$query = req.query, api_key = _req$query.api_key, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 100 : _req$query$limit, _req$query$offset = _req$query.offset, offset = _req$query$offset === void 0 ? 0 : _req$query$offset, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? "" : _req$query$search, _req$query$roleId = _req$query.roleId, roleId = _req$query$roleId === void 0 ? "" : _req$query$roleId;
          console.log("------", req.query);
          companyId = req.params.companyId;
          limit = parseInt(limit, 10) || 100; // Default limit to 100 if undefined or invalid
          offset = parseInt(offset, 10) || 0; // Default offset to 0 if undefined or invalid
          _context.prev = 5;
          api_key = _crypto["default"].decrypt(decodeURIComponent(api_key), _config["default"].adminCentral.crypto_secret);
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 9;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 9:
          if (companyId) {
            _context.next = 11;
            break;
          }
          throw new RequestError("UnAuthorized User", 401);
        case 11:
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition["$or"] = [{
              firstName: regex
            }, {
              lastName: regex
            }, {
              email: regex
            }];
          }
          if (roleId) {
            _context.next = 70;
            break;
          }
          _context.next = 16;
          return db.Employee.find(condition).skip(offset).limit(limit);
        case 16:
          _employees = _context.sent;
          _employeeIds = _employees.map(function (emp) {
            return emp._id;
          });
          _context.next = 20;
          return db.EmployeeRole.find({
            companyId: companyId,
            employeeId: {
              $in: _employeeIds
            },
            // Filter by the employee IDs
            deletedAt: null
          }).populate({
            path: "employeeId",
            select: "firstName lastName email isActive isVerify createdAt" // Populate relevant fields
          });
        case 20:
          _employeeRoles = _context.sent;
          _details = [];
          _iterator = _createForOfIteratorHelper(_employeeRoles);
          _context.prev = 23;
          _iterator.s();
        case 25:
          if ((_step = _iterator.n()).done) {
            _context.next = 58;
            break;
          }
          val = _step.value;
          obj = {};
          obj["id"] = val["employeeId"]["_id"];
          obj["firstName"] = val["employeeId"]["firstName"];
          obj["lastName"] = val["employeeId"]["lastName"];
          obj["email"] = val["employeeId"]["email"];
          obj["createdAt"] = val["employeeId"]["createdAt"];
          obj["type"] = "employee";
          obj["roleName"] = [];
          _iterator2 = _createForOfIteratorHelper(val.roleIds);
          _context.prev = 36;
          _iterator2.s();
        case 38:
          if ((_step2 = _iterator2.n()).done) {
            _context.next = 47;
            break;
          }
          _roleId = _step2.value;
          if (!_roleId.length) {
            _context.next = 45;
            break;
          }
          _context.next = 43;
          return db.Role.findOne({
            _id: _roleId
          });
        case 43:
          roleDetails = _context.sent;
          if (roleDetails) obj["roleName"].push(roleDetails.roleName);
        case 45:
          _context.next = 38;
          break;
        case 47:
          _context.next = 52;
          break;
        case 49:
          _context.prev = 49;
          _context.t0 = _context["catch"](36);
          _iterator2.e(_context.t0);
        case 52:
          _context.prev = 52;
          _iterator2.f();
          return _context.finish(52);
        case 55:
          _details.push(obj);
        case 56:
          _context.next = 25;
          break;
        case 58:
          _context.next = 63;
          break;
        case 60:
          _context.prev = 60;
          _context.t1 = _context["catch"](23);
          _iterator.e(_context.t1);
        case 63:
          _context.prev = 63;
          _iterator.f();
          return _context.finish(63);
        case 66:
          _context.next = 68;
          return db.Employee.countDocuments(condition);
        case 68:
          _count = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            response: {
              details: _details,
              count: _count
            }
          }));
        case 70:
          _context.next = 72;
          return db.Employee.find(condition).skip(offset).limit(limit);
        case 72:
          employees = _context.sent;
          employeeIds = employees.map(function (emp) {
            return emp._id;
          });
          _context.next = 76;
          return db.EmployeeRole.find({
            companyId: companyId,
            employeeId: {
              $in: employeeIds
            },
            // Filter by the employee IDs
            roleId: {
              $in: [roleId]
            },
            deletedAt: null
          }).populate({
            path: "employeeId",
            select: "firstName lastName email isActive isVerify createdAt" // Populate relevant fields
          });
        case 76:
          employeeRoles = _context.sent;
          details = [];
          _iterator3 = _createForOfIteratorHelper(employeeRoles);
          _context.prev = 79;
          _iterator3.s();
        case 81:
          if ((_step3 = _iterator3.n()).done) {
            _context.next = 113;
            break;
          }
          _val = _step3.value;
          _obj = {};
          _obj["id"] = _val["employeeId"]["_id"];
          _obj["firstName"] = _val["employeeId"]["firstName"];
          _obj["lastName"] = _val["employeeId"]["lastName"];
          _obj["email"] = _val["employeeId"]["email"];
          _obj["createdAt"] = _val["employeeId"]["createdAt"];
          _obj["type"] = "employee";
          _obj["roleName"] = [];
          _iterator4 = _createForOfIteratorHelper(_val.roleIds);
          _context.prev = 92;
          _iterator4.s();
        case 94:
          if ((_step4 = _iterator4.n()).done) {
            _context.next = 102;
            break;
          }
          _roleId2 = _step4.value;
          _context.next = 98;
          return db.Role.findOne({
            _id: _roleId2
          });
        case 98:
          _roleDetails = _context.sent;
          if (_roleDetails) _obj["roleName"].push(_roleDetails.roleName);
        case 100:
          _context.next = 94;
          break;
        case 102:
          _context.next = 107;
          break;
        case 104:
          _context.prev = 104;
          _context.t2 = _context["catch"](92);
          _iterator4.e(_context.t2);
        case 107:
          _context.prev = 107;
          _iterator4.f();
          return _context.finish(107);
        case 110:
          details.push(_obj);
        case 111:
          _context.next = 81;
          break;
        case 113:
          _context.next = 118;
          break;
        case 115:
          _context.prev = 115;
          _context.t3 = _context["catch"](79);
          _iterator3.e(_context.t3);
        case 118:
          _context.prev = 118;
          _iterator3.f();
          return _context.finish(118);
        case 121:
          _context.next = 123;
          return db.Employee.countDocuments(condition);
        case 123:
          count = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            response: {
              details: details,
              count: count
            }
          }));
        case 127:
          _context.prev = 127;
          _context.t4 = _context["catch"](5);
          statusCode = _context.t4.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error("API Error:", _context.t4);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t4.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t4.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t4.description || null // Optional additional info
            } : undefined
          });
        case 134:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[5, 127], [23, 60, 63, 66], [36, 49, 52, 55], [79, 115, 118, 121], [92, 104, 107, 110]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/:companyId").get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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