"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _crypto = _interopRequireDefault(require("../../crypto"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var api_key, companyId, policies, updatedPolicies, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          api_key = req.query.api_key;
          companyId = req.params.companyId;
          _context.prev = 2;
          api_key = _crypto["default"].decrypt(decodeURIComponent(api_key), _config["default"].adminCentral.crypto_secret);
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 6;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 6:
          if (companyId) {
            _context.next = 8;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 8:
          _context.next = 10;
          return db.Policy.find().lean();
        case 10:
          policies = _context.sent;
          updatedPolicies = policies.map(function (policy) {
            return _objectSpread(_objectSpread({}, policy), {}, {
              id: policy._id
            });
          });
          return _context.abrupt("return", res.status(200).json({
            response: updatedPolicies
          }));
        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](2);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 22:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[2, 15]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/:companyId').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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