"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, api_key, _req$query$search, search, companyId, condition, conditionForDefaultRoles, regex, roles, count, defaultRoles, details, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$query = req.query, api_key = _req$query.api_key, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? "" : _req$query$search;
          companyId = req.params.companyId;
          _context.prev = 2;
          api_key = _crypto["default"].decrypt(decodeURIComponent(api_key), _config["default"].adminCentral.crypto_secret);
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 6;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 6:
          if (companyId) {
            _context.next = 8;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 8:
          condition = {
            companyId: companyId
          };
          conditionForDefaultRoles = {
            roleType: "Default"
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition["$or"] = [{
              roleName: regex
            }];
            conditionForDefaultRoles["$or"] = [{
              roleName: regex
            }];
          }
          _context.next = 13;
          return db.Role.find(condition).select('roleName description');
        case 13:
          roles = _context.sent;
          _context.next = 16;
          return db.Role.countDocuments(condition);
        case 16:
          count = _context.sent;
          _context.next = 19;
          return db.Role.find(conditionForDefaultRoles);
        case 19:
          defaultRoles = _context.sent;
          roles = [].concat((0, _toConsumableArray2["default"])(roles), (0, _toConsumableArray2["default"])(defaultRoles));
          details = [];
          roles.forEach(function (val) {
            var obj = {};
            obj["id"] = val._id;
            obj["name"] = val.roleName;
            obj["description"] = val.description;
            details.push(obj);
          });
          return _context.abrupt("return", res.status(200).json({
            response: {
              details: details,
              count: count + defaultRoles.length
            }
          }));
        case 26:
          _context.prev = 26;
          _context.t0 = _context["catch"](2);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 33:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[2, 26]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/:companyId').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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