"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, tacCompanyId, api_key, _req$body$type, type, licenseKey, company, user, transformedUser, transformedCompany, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, tacCompanyId = _req$body.tacCompanyId, api_key = _req$body.api_key, _req$body$type = _req$body.type, type = _req$body$type === void 0 ? "root" : _req$body$type, licenseKey = _req$body.licenseKey;
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          _context.next = 6;
          return db.Company.findOne({
            tacLicenseKey: licenseKey,
            deletedAt: null
          });
        case 6:
          company = _context.sent;
          if (company) {
            _context.next = 9;
            break;
          }
          throw new RequestError('company not found!', 404);
        case 9:
          user = null;
          if (!(type == "root")) {
            _context.next = 16;
            break;
          }
          _context.next = 13;
          return db.Admin.findOne({
            email: email,
            companyId: company._id,
            isActive: true,
            isVerify: true,
            deletedAt: null
          });
        case 13:
          user = _context.sent;
          _context.next = 19;
          break;
        case 16:
          _context.next = 18;
          return db.Employee.findOne({
            email: email,
            companyId: company._id,
            isActive: true,
            isVerify: true,
            deletedAt: null
          });
        case 18:
          user = _context.sent;
        case 19:
          if (user) {
            _context.next = 21;
            break;
          }
          throw new RequestError("User not found", 404);
        case 21:
          transformedUser = {
            localMongoUserId: user._id,
            companyId: user.companyId
          };
          console.log({
            user: user,
            company: company
          });
          // Transform the result to rename _id to localMongoUserId
          transformedCompany = {
            localMongoCompanyId: company._id,
            localAlias: company.alias,
            logoPath: "".concat(_config["default"].app.url, "/api/static/logo/").concat(company.logo)
          };
          _context.next = 26;
          return db.Company.updateOne({
            _id: user.companyId
          }, {
            $set: {
              tacCompanyId: tacCompanyId
            }
          });
        case 26:
          console.log("fetch user - details se", transformedUser, transformedCompany);
          res.status(200).json({
            "success": true,
            "message": "All admins",
            "response": {
              user: transformedUser,
              company: transformedCompany
            }
          });
          _context.next = 37;
          break;
        case 30:
          _context.prev = 30;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 37:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 30]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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