"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var getVerifiedDomains = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(companyId) {
    var domains, results;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return db.Domain.find({
            isVerified: true,
            companyId: companyId,
            deletedAt: null
          }).lean();
        case 3:
          domains = _context2.sent;
          if (domains.length) {
            _context2.next = 6;
            break;
          }
          return _context2.abrupt("return", []);
        case 6:
          _context2.next = 8;
          return Promise.all(domains.map( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(domain) {
              var subdomains;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return db.SubDomainGroup.find({
                      domainId: domain._id,
                      companyId: companyId,
                      deletedAt: null
                    }).lean();
                  case 2:
                    subdomains = _context.sent;
                    console.log({
                      subdomains: subdomains
                    });
                    return _context.abrupt("return", {
                      name: domain.domainName,
                      txt: domain.txtRecord,
                      type: domain.domainType === "Gsuite" ? "Google Workspace" : domain.domainTypeForOutlook === "EXCHANGE" ? "Microsoft Outlook (Exchange)" : "Microsoft Outlook (O365)",
                      subDomains: subdomains.map(function (sub) {
                        return sub.groupName;
                      })
                    });
                  case 5:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x2) {
              return _ref2.apply(this, arguments);
            };
          }()));
        case 8:
          results = _context2.sent;
          return _context2.abrupt("return", results);
        case 12:
          _context2.prev = 12;
          _context2.t0 = _context2["catch"](0);
          console.error('Error fetching verified domains:', _context2.t0);
          return _context2.abrupt("return", []);
        case 16:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 12]]);
  }));
  return function getVerifiedDomains(_x) {
    return _ref.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, api_key, licenseKey, company, verifiedDomains, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context3.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          licenseKey = req.query.licenseKey;
          _context3.next = 7;
          return db.Company.findOne({
            tacLicenseKey: licenseKey
          });
        case 7:
          company = _context3.sent;
          if (company) {
            _context3.next = 10;
            break;
          }
          throw new RequestError("Invalid License Key", 400);
        case 10:
          _context3.next = 12;
          return getVerifiedDomains(company._id);
        case 12:
          verifiedDomains = _context3.sent;
          console.log({
            verifiedDomains: verifiedDomains
          });
          return _context3.abrupt("return", res.status(200).json({
            success: true,
            message: "Verified domains list",
            response: {
              verifiedDomains: verifiedDomains
            }
          }));
        case 17:
          _context3.prev = 17;
          _context3.t0 = _context3["catch"](0);
          statusCode = _context3.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context3.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context3.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context3.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context3.t0.description || null // Optional additional info
            } : undefined
          });
        case 24:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 17]]);
  }));
  return function controller(_x3, _x4, _x5) {
    return _ref3.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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