"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, licenseKey, company, metaData, groupsWithEmailAccess, exhaustedEmailUsersCount, groupsWithMessengerAccess, exhaustedWhatsappUsersCount, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          licenseKey = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          _context.next = 4;
          return db.Company.findOne({
            tacLicenseKey: licenseKey,
            deletedAt: null
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError("Company not found!");
        case 7:
          _context.next = 9;
          return db.MetaData.find({
            companyId: company._id,
            deletedAt: null
          });
        case 9:
          metaData = _context.sent;
          _context.next = 12;
          return db.Group.find({
            companyId: company._id,
            emailAccess: true,
            deletedAt: null
          });
        case 12:
          groupsWithEmailAccess = _context.sent;
          groupsWithEmailAccess = groupsWithEmailAccess.map(function (group) {
            return group._id;
          });
          _context.next = 16;
          return db.User.countDocuments({
            companyId: company._id,
            groups: {
              $in: groupsWithEmailAccess
            },
            deletedAt: null
          });
        case 16:
          exhaustedEmailUsersCount = _context.sent;
          _context.next = 19;
          return db.Group.find({
            companyId: company._id,
            messengerAccess: true,
            deletedAt: null
          });
        case 19:
          groupsWithMessengerAccess = _context.sent;
          groupsWithMessengerAccess = groupsWithMessengerAccess.map(function (group) {
            return group._id;
          });
          _context.next = 23;
          return db.User.countDocuments({
            companyId: company._id,
            groups: {
              $in: groupsWithMessengerAccess
            },
            deletedAt: null
          });
        case 23:
          exhaustedWhatsappUsersCount = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: true,
            exhaustedEmailUsersCount: exhaustedEmailUsersCount,
            exhaustedWhatsappUsersCount: exhaustedWhatsappUsersCount
          }));
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 34:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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