"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _dashboardHelper = _interopRequireDefault(require("../../service/dashboardHelper"));
var getGraphHeaders = {
  RETPIR1: ['Reporter', 'Mails Reported'],
  RETPIR2: ['Sender', 'Subject', 'Reporters', 'Date', 'Status'],
  RETPIR3: ['Url', 'Scan Score', 'Sender'],
  RETPIR4: ['Attachment', 'Scan Score', 'Sender'],
  RETPIR5: ['Sender', 'Total Emails', 'Receiver'],
  RETPIR6: []
};
var getGraphUnit = {
  RETPIR1: 'ArrayOfArray',
  RETPIR2: 'ArrayOfArray',
  RETPIR3: 'ArrayOfArray',
  RETPIR4: 'ArrayOfArray',
  RETPIR5: 'ArrayOfArray',
  RETPIR6: 'ArrayOfArray'
};
var optimizeResult = {
  RETPIR1: function RETPIR1(reporters) {
    return reporters.map(function (reporter) {
      return [[reporter.name || '', reporter.email || ''], reporter.count || 0];
    });
  },
  RETPIR2: function RETPIR2(emails) {
    return emails.map(function (email) {
      var emailStatus = Object.entries({
        isRecoveredEmail: email.isRecoveredEmail,
        isTrashedEmail: email.isTrashedEmail,
        isDeletedEmail: email.isDeletedEmail
      }).find(function (_ref) {
        var _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];
        return value === 'true';
      });
      return [[email.fromName || '', email.from || ''], email.subject || '', email.totalReporters || 0, email.createdAt || 'Unknown Date', emailStatus ? emailStatus[0] : 'No Action'];
    });
  },
  RETPIR3: function RETPIR3(urls) {
    return urls.map(function (url) {
      var _url$reportedMailId, _url$reportedMailId2;
      return [url.url || '', url.score || 0, [((_url$reportedMailId = url.reportedMailId) === null || _url$reportedMailId === void 0 ? void 0 : _url$reportedMailId.fromName) || '', ((_url$reportedMailId2 = url.reportedMailId) === null || _url$reportedMailId2 === void 0 ? void 0 : _url$reportedMailId2.from) || '']];
    });
  },
  RETPIR4: function RETPIR4(attachments) {
    return attachments.map(function (attachment) {
      var _attachment$reportedM, _attachment$reportedM2;
      return [attachment.filename || '', attachment.score || 0, [((_attachment$reportedM = attachment.reportedMailId) === null || _attachment$reportedM === void 0 ? void 0 : _attachment$reportedM.fromName) || '', ((_attachment$reportedM2 = attachment.reportedMailId) === null || _attachment$reportedM2 === void 0 ? void 0 : _attachment$reportedM2.from) || '']];
    });
  },
  RETPIR5: function RETPIR5(senders) {
    return senders.map(function (sender) {
      return [[sender.name || '', sender.email || ''], sender.reportedMailCount || 0, sender.whoElseCount || 0];
    });
  },
  RETPIR6: function RETPIR6(data) {
    return data;
  }
};
var controller = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers, _authHeader$split$, graphCode, _req$query, licenseKey, beginDate, endDate, authHeader, apiKey, company, condition, graphData, result, statusCode, isClientError;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          graphCode = req.params.graphCode;
          _req$query = req.query, licenseKey = _req$query.licenseKey, beginDate = _req$query.beginDate, endDate = _req$query.endDate;
          authHeader = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : _req$headers.authorization;
          apiKey = (_authHeader$split$ = authHeader === null || authHeader === void 0 ? void 0 : authHeader.split(' ')[1]) !== null && _authHeader$split$ !== void 0 ? _authHeader$split$ : null;
          if (!(apiKey !== _config["default"].adminCentral.api_key)) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 7:
          _context.next = 9;
          return db.Company.findOne({
            tacLicenseKey: licenseKey
          });
        case 9:
          company = _context.sent;
          if (company) {
            _context.next = 12;
            break;
          }
          throw new RequestError('Company not found!', 404);
        case 12:
          condition = {
            companyId: company._id
          };
          if (beginDate.length) condition[startDate] = beginDate;
          if (endDate.length) condition[endDate] = endDate;
          _context.next = 17;
          return (0, _dashboardHelper["default"])(graphCode, condition);
        case 17:
          graphData = _context.sent;
          if (!(!optimizeResult[graphCode] || !getGraphHeaders[graphCode])) {
            _context.next = 20;
            break;
          }
          throw new RequestError('Invalid graph code!', 400);
        case 20:
          result = {
            fields: optimizeResult[graphCode]((graphData === null || graphData === void 0 ? void 0 : graphData.data) || []),
            unit: getGraphUnit[graphCode],
            graphCode: graphCode,
            headers: getGraphHeaders[graphCode],
            label: (graphData === null || graphData === void 0 ? void 0 : graphData.label) || '',
            type: (graphData === null || graphData === void 0 ? void 0 : graphData.type) || ''
          };
          res.status(200).json({
            success: true,
            response: result
          });
          _context.next = 30;
          break;
        case 24:
          _context.prev = 24;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', {
            message: _context.t0.message,
            stack: _context.t0.stack
          });
          res.status(statusCode).json({
            success: false,
            message: isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.',
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 30:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 24]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref3.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/:graphCode').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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