"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _dashboardHelper = _interopRequireDefault(require("../../service/dashboardHelper"));
var graphFilters = {
  RETPIR1: ['dateTime'],
  RETPIR2: ['dateTime'],
  RETPIR3: ['dateTime'],
  RETPIR4: ['dateTime'],
  RETPIR5: ['dateTime'],
  RETPIR6: ['dateTime']
};
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, reportKey, api_key, filter, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          reportKey = req.query.reportKey;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 5:
          filter = graphFilters[reportKey];
          res.status(200).json({
            "success": true,
            "response": filter
          });
          _context.next = 16;
          break;
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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