"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
function getRoleWithPolicies(_x, _x2) {
  return _getRoleWithPolicies.apply(this, arguments);
}
function _getRoleWithPolicies() {
  _getRoleWithPolicies = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(roleId, companyId) {
    var allPolicies, role, rolePolicyIds, policiesArray, roleResult;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return db.Policy.find();
        case 3:
          allPolicies = _context2.sent;
          _context2.next = 6;
          return db.Role.findOne({
            _id: roleId
          }).populate("policyIds");
        case 6:
          role = _context2.sent;
          if (role) {
            _context2.next = 9;
            break;
          }
          throw new Error("Role not found");
        case 9:
          rolePolicyIds = new Set(role === null || role === void 0 ? void 0 : role.policyIds.map(function (policy) {
            return policy._id.toString();
          }));
          policiesArray = allPolicies.map(function (policy) {
            return {
              id: policy._id,
              name: policy.name,
              isTrue: rolePolicyIds.has(policy._id.toString())
            };
          });
          roleResult = {
            id: role._id,
            name: role.roleName,
            description: role.description,
            companyId: role.companyId,
            type: role.roleType,
            policies: policiesArray
          };
          return _context2.abrupt("return", roleResult);
        case 15:
          _context2.prev = 15;
          _context2.t0 = _context2["catch"](0);
          console.error(_context2.t0);
        case 18:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 15]]);
  }));
  return _getRoleWithPolicies.apply(this, arguments);
}
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, api_key, roleId, companyId, role, roleWithPolicies, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(api_key !== _config["default"].adminCentral.api_key || !api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 4:
          roleId = req.query.roleId;
          companyId = req.params.companyId;
          console.log({
            roleId: roleId,
            companyId: companyId
          });
          if (roleId) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Role ID is required.', 400);
        case 9:
          _context.next = 11;
          return db.Role.findOne({
            _id: roleId
          }).populate("policyIds");
        case 11:
          role = _context.sent;
          if (role) {
            _context.next = 14;
            break;
          }
          throw new RequestError('Role not found.', 404);
        case 14:
          _context.next = 16;
          return getRoleWithPolicies(roleId, companyId);
        case 16:
          roleWithPolicies = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: true,
            data: roleWithPolicies
          }));
        case 20:
          _context.prev = 20;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 27:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 20]]);
  }));
  return function controller(_x3, _x4, _x5) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/:companyId').get(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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