"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, appName, _req$query, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, offset, company, response, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          appName = "TPIR";
          _req$query = req.query, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? "" : _req$query$search;
          limit = limit ? parseInt(limit, 10) : 10;
          offset = page ? (parseInt(page, 10) - 1) * limit : 0;
          _context.next = 8;
          return db.Company.findOne({
            _id: companyId
          });
        case 8:
          company = _context.sent;
          if (company) {
            _context.next = 11;
            break;
          }
          throw new RequestError("Company not found!", 404);
        case 11:
          _context.next = 13;
          return axios.get("".concat(process.env.TAC_URL, "/api/sync-services/common/list-tac-users"), _objectSpread({
            headers: {
              'Content-Type': 'application/json',
              'Authorization': "Bearer ".concat(_config["default"].adminCentral.api_key)
            },
            params: {
              companyId: company.tacCompanyId,
              offset: offset,
              limit: limit,
              appName: appName,
              search: search
            }
          }, _config["default"].proxy.enableForTA && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 13:
          response = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Users list retrieved successfully",
            response: response.data.response
          }));
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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