"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, api_key, groupDetails, localCompanyId, userToDeleteDetails, groupIds, groups, groupObjectIds, identityKeys, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, api_key = _req$body.api_key, groupDetails = _req$body.groupDetails, localCompanyId = _req$body.localCompanyId, userToDeleteDetails = _req$body.userToDeleteDetails;
          console.log("Received data:", req.body);
          if (!(api_key !== _config["default"].adminCentral.api_key || !api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 5:
          console.log("Processing group deletions", groupDetails);
          groupIds = groupDetails.map(function (groupDetail) {
            return groupDetail.identityKey;
          });
          _context.next = 9;
          return db.Group.find({
            tacIdentityKey: {
              $in: groupIds
            },
            companyId: localCompanyId
          });
        case 9:
          groups = _context.sent;
          groupObjectIds = groups.map(function (group) {
            return group._id;
          });
          _context.next = 13;
          return db.User.updateMany({
            companyId: localCompanyId,
            groups: {
              $in: groupObjectIds
            }
          }, {
            $pull: {
              groups: {
                $in: groupObjectIds
              }
            }
          });
        case 13:
          _context.next = 15;
          return db.User.deleteMany({
            companyId: localCompanyId,
            groups: {
              $size: 1
            },
            deletedAt: null
          });
        case 15:
          _context.next = 17;
          return db.Group.deleteMany({
            _id: {
              $in: groupObjectIds
            },
            companyId: localCompanyId,
            isDefaultGroup: false
          });
        case 17:
          if (!(Array.isArray(userToDeleteDetails) && userToDeleteDetails.length > 0)) {
            _context.next = 22;
            break;
          }
          identityKeys = userToDeleteDetails.map(function (user) {
            return user.IdentityKey;
          }).filter(Boolean);
          if (!(identityKeys.length > 0)) {
            _context.next = 22;
            break;
          }
          _context.next = 22;
          return db.User.deleteMany({
            tacIdentityKey: {
              $in: identityKeys
            },
            companyId: localCompanyId,
            deletedAt: null
          });
        case 22:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Groups deleted successfully."
          }));
        case 25:
          _context.prev = 25;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 25]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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