"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, api_key, groupDetails, userDetails, lastSyncId, willGroupDelete, removeUserFromApplicationDetails, companyId, group, allUsersGroup, _iterator, _step, user, usr, updatedUser, updatedUserCountInGroup, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, api_key = _req$body.api_key, groupDetails = _req$body.groupDetails, userDetails = _req$body.userDetails, lastSyncId = _req$body.lastSyncId, willGroupDelete = _req$body.willGroupDelete, removeUserFromApplicationDetails = _req$body.removeUserFromApplicationDetails;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 4:
          companyId = groupDetails.localCompanyId;
          _context.next = 7;
          return db.Group.findOne({
            tacIdentityKey: groupDetails.identityKey,
            companyId: companyId
          });
        case 7:
          group = _context.sent;
          console.log({
            group: group
          });
          if (group) {
            _context.next = 11;
            break;
          }
          throw new RequestError("Group not found!");
        case 11:
          _context.next = 13;
          return db.Group.findOne({
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            companyId: companyId
          }).select('_id');
        case 13:
          allUsersGroup = _context.sent;
          console.log({
            allUsersGroup: allUsersGroup
          });
          _iterator = _createForOfIteratorHelper(userDetails);
          _context.prev = 16;
          _iterator.s();
        case 18:
          if ((_step = _iterator.n()).done) {
            _context.next = 34;
            break;
          }
          user = _step.value;
          _context.next = 22;
          return db.User.findOne({
            tacIdentityKey: user.IdentityKey,
            email: user.userEmail,
            companyId: companyId
          });
        case 22:
          usr = _context.sent;
          console.log({
            usr: usr
          });
          if (!usr) {
            _context.next = 32;
            break;
          }
          _context.next = 27;
          return db.User.findByIdAndUpdate(usr._id, {
            $pull: {
              groups: group._id
            }
          });
        case 27:
          updatedUser = _context.sent;
          console.log({
            updatedUser: updatedUser
          });
          if (!(updatedUser.groups.length === 1 && updatedUser.groups.includes(allUsersGroup._id))) {
            _context.next = 32;
            break;
          }
          _context.next = 32;
          return db.User.deleteOne({
            _id: updatedUser._id,
            companyId: companyId
          });
        case 32:
          _context.next = 18;
          break;
        case 34:
          _context.next = 39;
          break;
        case 36:
          _context.prev = 36;
          _context.t0 = _context["catch"](16);
          _iterator.e(_context.t0);
        case 39:
          _context.prev = 39;
          _iterator.f();
          return _context.finish(39);
        case 42:
          _context.next = 44;
          return db.User.countDocuments({
            companyId: companyId,
            groups: {
              $in: [group._id]
            }
          });
        case 44:
          updatedUserCountInGroup = _context.sent;
          if (!updatedUserCountInGroup) {
            _context.next = 50;
            break;
          }
          _context.next = 48;
          return db.Group.updateOne({
            _id: group._id,
            companyId: companyId
          }, {
            $set: {
              tacIdentityKey: groupDetails.identityKey,
              lastSyncId: groupDetails.lastSyncId
            }
          });
        case 48:
          _context.next = 53;
          break;
        case 50:
          if (!(!updatedUserCountInGroup && willGroupDelete)) {
            _context.next = 53;
            break;
          }
          _context.next = 53;
          return db.Group.deleteOne({
            companyId: companyId,
            _id: group._id
          });
        case 53:
          if (!(removeUserFromApplicationDetails && removeUserFromApplicationDetails.length)) {
            _context.next = 56;
            break;
          }
          _context.next = 56;
          return db.User.deleteMany({
            tacIdentityKey: {
              $in: removeUserFromApplicationDetails.map(function (user) {
                return user.IdentityKey;
              })
            },
            companyId: companyId
          });
        case 56:
          return _context.abrupt("return", res.status(200).json({
            message: "done"
          }));
        case 59:
          _context.prev = 59;
          _context.t1 = _context["catch"](0);
          statusCode = _context.t1.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t1);
          responseMessage = isClientError ? _context.t1.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t1.code || 'UNEXPECTED_ERROR',
              description: _context.t1.description || null
            } : undefined
          });
        case 66:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 59], [16, 36, 39, 42]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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