"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, identityKeys, api_key, lastSyncId, users, groupIds, userIds, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, identityKeys = _req$body.identityKeys, api_key = _req$body.api_key, lastSyncId = _req$body.lastSyncId;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 4:
          _context.next = 6;
          return db.User.find({
            tacIdentityKey: {
              $in: identityKeys
            }
          }, {
            _id: 1,
            groups: 1
          });
        case 6:
          users = _context.sent;
          if (users.length) {
            _context.next = 9;
            break;
          }
          return _context.abrupt("return", res.status(404).json({
            message: "No users found"
          }));
        case 9:
          groupIds = (0, _toConsumableArray2["default"])(new Set(users.flatMap(function (user) {
            return user.groups;
          })));
          console.log({
            groupIds: groupIds
          });
          userIds = users.map(function (user) {
            return user._id;
          });
          _context.next = 14;
          return db.User.deleteMany({
            _id: {
              $in: userIds
            }
          });
        case 14:
          if (!groupIds.length) {
            _context.next = 17;
            break;
          }
          _context.next = 17;
          return db.Group.updateMany({
            _id: {
              $in: groupIds
            }
          }, {
            $set: {
              lastSyncId: lastSyncId
            }
          });
        case 17:
          return _context.abrupt("return", res.status(200).json({
            message: "Users deleted successfully"
          }));
        case 20:
          _context.prev = 20;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 27:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 20]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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