"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _axios = _interopRequireDefault(require("axios"));
var _strategy = require("../../middlewares/strategy");
var _kue = require("../../kue");
var _syncDomains = require("../../service/syncDomains");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var syncGroupUsers = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _apiResponse$data, _apiResponse$data$res, companyId, company, syncDomains, groupsFromDb, groupMap, mismatchedGroups, _iterator, _step, _group, userCount, apiResponse, apiGroups, _iterator2, _step2, apiGroup, groupIdentityKey, apiUserCount, lastSyncId, dbGroup, isMismatch, allUsersGroup, i, group, groupTPIR;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Company.findOne({
            _id: companyId,
            deletedAt: null
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError("Company not found", 404);
        case 7:
          _context.next = 9;
          return (0, _syncDomains.syncDomainsFromTa)(company._id);
        case 9:
          syncDomains = _context.sent;
          _context.next = 12;
          return db.Group.find({
            companyId: companyId,
            isDefaultGroup: false,
            deletedAt: null,
            type: "Admin",
            lastSyncIdMismatch: true
          }).lean();
        case 12:
          groupsFromDb = _context.sent;
          groupMap = {};
          mismatchedGroups = [];
          _iterator = _createForOfIteratorHelper(groupsFromDb);
          _context.prev = 16;
          _iterator.s();
        case 18:
          if ((_step = _iterator.n()).done) {
            _context.next = 26;
            break;
          }
          _group = _step.value;
          _context.next = 22;
          return db.User.countDocuments({
            groups: {
              $in: [_group._id]
            },
            deletedAt: null
          });
        case 22:
          userCount = _context.sent;
          groupMap[_group.tacIdentityKey] = _objectSpread(_objectSpread({}, _group), {}, {
            userCount: userCount
          });
        case 24:
          _context.next = 18;
          break;
        case 26:
          _context.next = 31;
          break;
        case 28:
          _context.prev = 28;
          _context.t0 = _context["catch"](16);
          _iterator.e(_context.t0);
        case 31:
          _context.prev = 31;
          _iterator.f();
          return _context.finish(31);
        case 34:
          _context.next = 36;
          return _axios["default"].get("".concat(process.env.TAC_URL, "/api/sync-services/common/fetch-group-user-count"), _objectSpread({
            headers: {
              "Content-Type": "application/json",
              Authorization: "Bearer ".concat(company.tacLicenseKey)
            }
          }, config.proxy.enableForTA && {
            httpsAgent: config.proxy.proxyAgent,
            httpAgent: config.proxy.proxyAgent
          }));
        case 36:
          apiResponse = _context.sent;
          apiGroups = apiResponse === null || apiResponse === void 0 ? void 0 : (_apiResponse$data = apiResponse.data) === null || _apiResponse$data === void 0 ? void 0 : (_apiResponse$data$res = _apiResponse$data.response) === null || _apiResponse$data$res === void 0 ? void 0 : _apiResponse$data$res.groupUserCount;
          _iterator2 = _createForOfIteratorHelper(apiGroups);
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              apiGroup = _step2.value;
              groupIdentityKey = apiGroup.groupIdentityKey, apiUserCount = apiGroup.userCount, lastSyncId = apiGroup.lastSyncId;
              dbGroup = groupMap[groupIdentityKey];
              if (dbGroup) {
                isMismatch = dbGroup.lastSyncId !== lastSyncId || dbGroup.userCount !== apiUserCount;
                console.log({
                  dbGroup: dbGroup,
                  lastSyncId: lastSyncId
                });
                if (isMismatch) {
                  mismatchedGroups.push(_objectSpread(_objectSpread({}, dbGroup), {}, {
                    lastSyncId: lastSyncId,
                    apiUserCount: apiUserCount
                  }));
                }
              }
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
          _context.next = 42;
          return db.Group.findOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          });
        case 42:
          allUsersGroup = _context.sent;
          console.log({
            mismatchedGroups: mismatchedGroups
          });
          i = 0;
        case 45:
          if (!(i < mismatchedGroups.length)) {
            _context.next = 59;
            break;
          }
          group = mismatchedGroups[i];
          console.log({
            group: group
          });
          _context.next = 50;
          return db.Group.findOneAndUpdate({
            groupName: group.groupName,
            companyId: group.companyId
          }, {
            $set: {
              isSyncingUsers: true
            }
          });
        case 50:
          groupTPIR = _context.sent;
          _context.next = 53;
          return db.User.deleteMany({
            groups: {
              $all: [allUsersGroup._id, group._id],
              $size: 2
            },
            companyId: companyId
          });
        case 53:
          _context.next = 55;
          return db.User.updateMany({
            groups: {
              $all: [allUsersGroup._id, group._id]
            },
            $expr: {
              $gt: [{
                $size: "$groups"
              }, 2]
            } // Size > 2
          }, {
            $pull: {
              groups: group._id
            }
          });
        case 55:
          if (groupTPIR) {
            _kue.queue.create('retry-syncing-users', {
              localGroupId: groupTPIR._id,
              localCompanyId: group.companyId,
              tacIdentityKey: group.tacIdentityKey,
              tacCompanyId: company.tacCompanyId,
              memberCount: group.apiUserCount,
              licenseKey: company.tacLicenseKey,
              lastSyncId: group.lastSyncId
            }).removeOnComplete(true).save();
          }
        case 56:
          i++;
          _context.next = 45;
          break;
        case 59:
          res.status(200).json({
            success: true,
            message: "Syncing started successfully!"
          });
          _context.next = 66;
          break;
        case 62:
          _context.prev = 62;
          _context.t1 = _context["catch"](0);
          console.error(_context.t1);
          next(_context.t1);
        case 66:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 62], [16, 28, 31, 34]]);
  }));
  return function syncGroupUsers(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, syncGroupUsers);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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