"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _functions = require("../../functions");
var _mailer = _interopRequireDefault(require("../../mailer"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _config = _interopRequireDefault(require("../../config"));
var _packageHelper = _interopRequireDefault(require("../../service/package-helper"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, _req$body, endDate, emailUsersCount, whatsappUsersCount, domainCount, company, users, packageDetails, licenseKey, isCompanyExist, _req$body$users, firstName, lastName, User, isAdminExist, metaData, key, update, passwordHash, decryptedPassword, admin, _setPackage, licenseFormat, _key, _update, setPackage, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, endDate = _req$body.endDate, emailUsersCount = _req$body.emailUsersCount, whatsappUsersCount = _req$body.whatsappUsersCount, domainCount = _req$body.domainCount, company = _req$body.company, users = _req$body.users, packageDetails = _req$body.packageDetails;
          licenseKey = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          console.log({
            licenseKey: licenseKey
          });
          _context.next = 6;
          return db.Company.findOne({
            tacLicenseKey: licenseKey,
            deletedAt: null
          });
        case 6:
          isCompanyExist = _context.sent;
          console.log({
            isCompanyExist: isCompanyExist
          });
          if (isCompanyExist) {
            _context.next = 45;
            break;
          }
          _req$body$users = req.body.users, firstName = _req$body$users.firstName, lastName = _req$body$users.lastName, User = _req$body$users.User;
          _context.next = 12;
          return db.Admin.findOne({
            email: User === null || User === void 0 ? void 0 : User.email,
            deletedAt: null
          });
        case 12:
          isAdminExist = _context.sent;
          if (!isAdminExist) {
            _context.next = 17;
            break;
          }
          _context.next = 16;
          return db.Admin.updateOne({
            email: User === null || User === void 0 ? void 0 : User.email,
            deletedAt: null
          }, {
            $set: {
              tacIdentityKey: User === null || User === void 0 ? void 0 : User.IdentityKey
            }
          });
        case 16:
          throw new RequestError("Admin with ".concat(isAdminExist.email, " already exists!"));
        case 17:
          _context.next = 19;
          return db.Company.create({
            name: company.companyName,
            tacLicenseKey: licenseKey,
            alias: company === null || company === void 0 ? void 0 : company.alias,
            tacCompanyId: company.id,
            isTacEnabled: true,
            isNewCompany: true,
            industry: company === null || company === void 0 ? void 0 : company.industry,
            country: company === null || company === void 0 ? void 0 : company.country
          });
        case 19:
          isCompanyExist = _context.sent;
          metaData = {
            tsatUrl: 'https://tsat.threatcop.com',
            isTsat: "false",
            mailSmtp: false
          };
          _context.t0 = _regenerator["default"].keys(metaData);
        case 22:
          if ((_context.t1 = _context.t0()).done) {
            _context.next = 30;
            break;
          }
          key = _context.t1.value;
          _context.next = 26;
          return db.MetaData.findOneAndUpdate({
            companyId: isCompanyExist._id,
            name: key
          }, {
            value: metaData[key]
          }, {
            upsert: true,
            "new": true,
            setDefaultsOnInsert: true
          });
        case 26:
          update = _context.sent;
          console.log({
            update: update,
            key: key
          });
          _context.next = 22;
          break;
        case 30:
          _context.next = 32;
          return db.Group.create({
            groupName: "all-users-tpir",
            type: "Custom",
            isDefaultGroup: true,
            emailAccess: false,
            messengerAccess: false,
            companyId: isCompanyExist._id,
            createdAt: new Date('9999-12-31')
          });
        case 32:
          if (!(User !== null && User !== void 0 && User.meta)) {
            _context.next = 38;
            break;
          }
          decryptedPassword = _crypto["default"].decrypt(User.meta, _config["default"].adminCentral.crypto_secret);
          if (decryptedPassword) {
            _context.next = 36;
            break;
          }
          throw new RequestError('Request from invalid source, meta decryption failed.', 409);
        case 36:
          console.log({
            aaaa: decryptedPassword
          });
          passwordHash = _bcryptjs["default"].hashSync(decryptedPassword);
        case 38:
          console.log({
            isCompanyExist: isCompanyExist
          });
          _context.next = 41;
          return db.Admin.create({
            firstName: firstName,
            lastName: lastName,
            email: User === null || User === void 0 ? void 0 : User.email,
            password: passwordHash,
            isActive: true,
            isVerify: true,
            companyId: isCompanyExist._id,
            verfKey: (0, _functions.randomString)(10),
            verfKeyExpiry: new Date(),
            tacIdentityKey: User === null || User === void 0 ? void 0 : User.IdentityKey
          });
        case 41:
          admin = _context.sent;
          _context.next = 44;
          return _packageHelper["default"].setPackageDetails(isCompanyExist, packageDetails);
        case 44:
          _setPackage = _context.sent;
        case 45:
          _context.next = 47;
          return db.Company.updateOne({
            tacLicenseKey: licenseKey
          }, {
            $set: {
              packageAccessKey: packageDetails === null || packageDetails === void 0 ? void 0 : packageDetails.packageAccessKey,
              alias: company === null || company === void 0 ? void 0 : company.alias
            }
          });
        case 47:
          licenseFormat = {
            expiredAt: endDate,
            userLimit: emailUsersCount,
            userLimitMessenger: whatsappUsersCount,
            domainLimit: domainCount
          };
          _context.t2 = _regenerator["default"].keys(licenseFormat);
        case 49:
          if ((_context.t3 = _context.t2()).done) {
            _context.next = 57;
            break;
          }
          _key = _context.t3.value;
          _context.next = 53;
          return db.MetaData.findOneAndUpdate({
            companyId: isCompanyExist._id,
            name: _key
          }, {
            value: licenseFormat[_key]
          }, {
            upsert: true,
            "new": true,
            setDefaultsOnInsert: true
          });
        case 53:
          _update = _context.sent;
          console.log({
            update: _update,
            key: _key
          });
          _context.next = 49;
          break;
        case 57:
          _context.next = 59;
          return _packageHelper["default"].setPackageDetails(isCompanyExist, packageDetails);
        case 59:
          setPackage = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            messages: "License updated successfully"
          }));
        case 63:
          _context.prev = 63;
          _context.t4 = _context["catch"](0);
          statusCode = _context.t4.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t4);
          responseMessage = isClientError ? _context.t4.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t4.code || 'UNEXPECTED_ERROR',
              description: _context.t4.description || null
            } : undefined
          });
        case 70:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 63]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImJvZHkiLCJlbmREYXRlIiwiZW1haWxVc2Vyc0NvdW50Iiwid2hhdHNhcHBVc2Vyc0NvdW50IiwiZG9tYWluQ291bnQiLCJjb21wYW55IiwidXNlcnMiLCJwYWNrYWdlRGV0YWlscyIsImxpY2Vuc2VLZXkiLCJoZWFkZXJzIiwiYXV0aG9yaXphdGlvbiIsInNwbGl0IiwiY29uc29sZSIsImxvZyIsImRiIiwiQ29tcGFueSIsImZpbmRPbmUiLCJ0YWNMaWNlbnNlS2V5IiwiZGVsZXRlZEF0IiwiaXNDb21wYW55RXhpc3QiLCJmaXJzdE5hbWUiLCJsYXN0TmFtZSIsIlVzZXIiLCJBZG1pbiIsImVtYWlsIiwiaXNBZG1pbkV4aXN0IiwidXBkYXRlT25lIiwiJHNldCIsInRhY0lkZW50aXR5S2V5IiwiSWRlbnRpdHlLZXkiLCJSZXF1ZXN0RXJyb3IiLCJjcmVhdGUiLCJuYW1lIiwiY29tcGFueU5hbWUiLCJhbGlhcyIsInRhY0NvbXBhbnlJZCIsImlkIiwiaXNUYWNFbmFibGVkIiwiaXNOZXdDb21wYW55IiwiaW5kdXN0cnkiLCJjb3VudHJ5IiwibWV0YURhdGEiLCJ0c2F0VXJsIiwiaXNUc2F0IiwibWFpbFNtdHAiLCJrZXkiLCJNZXRhRGF0YSIsImZpbmRPbmVBbmRVcGRhdGUiLCJjb21wYW55SWQiLCJfaWQiLCJ2YWx1ZSIsInVwc2VydCIsInNldERlZmF1bHRzT25JbnNlcnQiLCJ1cGRhdGUiLCJHcm91cCIsImdyb3VwTmFtZSIsInR5cGUiLCJpc0RlZmF1bHRHcm91cCIsImVtYWlsQWNjZXNzIiwibWVzc2VuZ2VyQWNjZXNzIiwiY3JlYXRlZEF0IiwiRGF0ZSIsIm1ldGEiLCJkZWNyeXB0ZWRQYXNzd29yZCIsImNyeXB0byIsImRlY3J5cHQiLCJjb25maWciLCJhZG1pbkNlbnRyYWwiLCJjcnlwdG9fc2VjcmV0IiwiYWFhYSIsInBhc3N3b3JkSGFzaCIsImJjcnlwdCIsImhhc2hTeW5jIiwicGFzc3dvcmQiLCJpc0FjdGl2ZSIsImlzVmVyaWZ5IiwidmVyZktleSIsInJhbmRvbVN0cmluZyIsInZlcmZLZXlFeHBpcnkiLCJhZG1pbiIsInBhY2thZ2VIZWxwZXIiLCJzZXRQYWNrYWdlRGV0YWlscyIsInNldFBhY2thZ2UiLCJwYWNrYWdlQWNjZXNzS2V5IiwibGljZW5zZUZvcm1hdCIsImV4cGlyZWRBdCIsInVzZXJMaW1pdCIsInVzZXJMaW1pdE1lc3NlbmdlciIsImRvbWFpbkxpbWl0Iiwic3RhdHVzIiwianNvbiIsIm1lc3NhZ2VzIiwic3RhdHVzQ29kZSIsImlzQ2xpZW50RXJyb3IiLCJlcnJvciIsInJlc3BvbnNlTWVzc2FnZSIsIm1lc3NhZ2UiLCJzdWNjZXNzIiwiY29kZSIsImRlc2NyaXB0aW9uIiwidW5kZWZpbmVkIiwiYXBpUm91dGVyIiwiZXhwcmVzcyIsIlJvdXRlciIsInJvdXRlIiwicG9zdCJdLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9hcGkvYWRtaW5DZW50cmFsL3NhdmUtbGljZW5zZS5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZXhwcmVzcyBmcm9tICdleHByZXNzJztcbmltcG9ydCB7IHJhbmRvbVN0cmluZyB9IGZyb20gJy4uLy4uL2Z1bmN0aW9ucyc7XG5pbXBvcnQgbWFpbGVyIGZyb20gJy4uLy4uL21haWxlcic7XG5pbXBvcnQgY3J5cHRvIGZyb20gJy4uLy4uL2NyeXB0byc7XG5pbXBvcnQgYmNyeXB0IGZyb20gJ2JjcnlwdGpzJztcbmltcG9ydCBjb25maWcgZnJvbSAnLi4vLi4vY29uZmlnJ1xuaW1wb3J0IHBhY2thZ2VIZWxwZXIgZnJvbSAnLi4vLi4vc2VydmljZS9wYWNrYWdlLWhlbHBlcic7XG5cblxubGV0IGNvbnRyb2xsZXIgPSBhc3luYyAocmVxLCByZXMsIG5leHQpID0+IHtcbiAgICB0cnl7XG4gICAgICAgIGNvbnN0IHtlbmREYXRlLCBlbWFpbFVzZXJzQ291bnQsIHdoYXRzYXBwVXNlcnNDb3VudCwgZG9tYWluQ291bnQsIGNvbXBhbnksIHVzZXJzLCBwYWNrYWdlRGV0YWlsc30gPSByZXEuYm9keVxuICAgIFxuICAgICAgICBjb25zdCBsaWNlbnNlS2V5PSByZXE/LmhlYWRlcnM/LmF1dGhvcml6YXRpb24/LnNwbGl0KCcgJylbMV0gPz8gbnVsbDtcbiAgICAgICAgY29uc29sZS5sb2coe2xpY2Vuc2VLZXl9KVxuXG4gICAgICAgIGxldCBpc0NvbXBhbnlFeGlzdCA9IGF3YWl0IGRiLkNvbXBhbnkuZmluZE9uZSh7dGFjTGljZW5zZUtleTogbGljZW5zZUtleSwgZGVsZXRlZEF0Om51bGx9KVxuICAgICAgICBjb25zb2xlLmxvZyh7aXNDb21wYW55RXhpc3R9KVxuICAgICAgICBpZighaXNDb21wYW55RXhpc3QpIHtcbiAgICAgICAgICAgIGNvbnN0IHsgZmlyc3ROYW1lLCBsYXN0TmFtZSwgVXNlciB9ID0gcmVxLmJvZHkudXNlcnM7XG5cbiAgICAgICAgICAgIGNvbnN0IGlzQWRtaW5FeGlzdCA9IGF3YWl0IGRiLkFkbWluLmZpbmRPbmUoe2VtYWlsOiBVc2VyPy5lbWFpbCwgZGVsZXRlZEF0OiBudWxsfSlcbiAgICAgICAgICAgIGlmKGlzQWRtaW5FeGlzdCkge1xuICAgICAgICAgICAgICAgIGF3YWl0IGRiLkFkbWluLnVwZGF0ZU9uZSh7ZW1haWw6IFVzZXI/LmVtYWlsLCBkZWxldGVkQXQ6IG51bGx9LHskc2V0Ont0YWNJZGVudGl0eUtleTogVXNlcj8uSWRlbnRpdHlLZXl9fSlcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgUmVxdWVzdEVycm9yKGBBZG1pbiB3aXRoICR7aXNBZG1pbkV4aXN0LmVtYWlsfSBhbHJlYWR5IGV4aXN0cyFgKVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpc0NvbXBhbnlFeGlzdCA9IGF3YWl0IGRiLkNvbXBhbnkuY3JlYXRlKHtcbiAgICAgICAgICAgICAgICBuYW1lOiBjb21wYW55LmNvbXBhbnlOYW1lLCB0YWNMaWNlbnNlS2V5OiBsaWNlbnNlS2V5LCBhbGlhczogY29tcGFueT8uYWxpYXMsXG4gICAgICAgICAgICAgICAgdGFjQ29tcGFueUlkOiBjb21wYW55LmlkLCBpc1RhY0VuYWJsZWQ6IHRydWUsIGlzTmV3Q29tcGFueTogdHJ1ZSwgaW5kdXN0cnk6IGNvbXBhbnk/LmluZHVzdHJ5LCBjb3VudHJ5OiBjb21wYW55Py5jb3VudHJ5XG4gICAgICAgICAgICB9KVxuXG4gICAgICAgICAgICBjb25zdCBtZXRhRGF0YSA9IHtcbiAgICAgICAgICAgICAgICB0c2F0VXJsOiAnaHR0cHM6Ly90c2F0LnRocmVhdGNvcC5jb20nLFxuICAgICAgICAgICAgICAgIGlzVHNhdDogXCJmYWxzZVwiLFxuICAgICAgICAgICAgICAgIG1haWxTbXRwOiBmYWxzZSxcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgZm9yIChsZXQga2V5IGluIG1ldGFEYXRhKSB7XG4gICAgICAgICAgICAgICAgY29uc3QgdXBkYXRlID0gYXdhaXQgZGIuTWV0YURhdGEuZmluZE9uZUFuZFVwZGF0ZSh7XG4gICAgICAgICAgICAgICAgICAgIGNvbXBhbnlJZDogaXNDb21wYW55RXhpc3QuX2lkLFxuICAgICAgICAgICAgICAgICAgICBuYW1lOiBrZXksXG4gICAgICAgICAgICAgICAgfSx7XG4gICAgICAgICAgICAgICAgICAgIHZhbHVlOiBtZXRhRGF0YVtrZXldXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICB7IHVwc2VydDogdHJ1ZSwgbmV3OiB0cnVlLCBzZXREZWZhdWx0c09uSW5zZXJ0OiB0cnVlIH0pXG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe3VwZGF0ZSwga2V5fSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFxuICAgICAgICAgICAgYXdhaXQgZGIuR3JvdXAuY3JlYXRlKHtcbiAgICAgICAgICAgICAgICBncm91cE5hbWU6IFwiYWxsLXVzZXJzLXRwaXJcIixcbiAgICAgICAgICAgICAgICB0eXBlOlwiQ3VzdG9tXCIsXG4gICAgICAgICAgICAgICAgaXNEZWZhdWx0R3JvdXA6IHRydWUsXG4gICAgICAgICAgICAgICAgZW1haWxBY2Nlc3M6IGZhbHNlLFxuICAgICAgICAgICAgICAgIG1lc3NlbmdlckFjY2VzczogZmFsc2UsXG4gICAgICAgICAgICAgICAgY29tcGFueUlkOiBpc0NvbXBhbnlFeGlzdC5faWQsXG4gICAgICAgICAgICAgICAgY3JlYXRlZEF0OiBuZXcgRGF0ZSgnOTk5OS0xMi0zMScpXG4gICAgICAgICAgICB9KVxuICAgICAgICAgICAgXG4gICAgICAgICAgICBsZXQgcGFzc3dvcmRIYXNoO1xuICAgICAgICAgICAgaWYgKFVzZXI/Lm1ldGEpIHsgXG4gICAgICAgICAgICAgICAgY29uc3QgZGVjcnlwdGVkUGFzc3dvcmQgPSBjcnlwdG8uZGVjcnlwdChVc2VyLm1ldGEsIGNvbmZpZy5hZG1pbkNlbnRyYWwuY3J5cHRvX3NlY3JldCk7XG4gICAgICAgICAgICAgICAgaWYgKCFkZWNyeXB0ZWRQYXNzd29yZCkge1xuICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgUmVxdWVzdEVycm9yKCdSZXF1ZXN0IGZyb20gaW52YWxpZCBzb3VyY2UsIG1ldGEgZGVjcnlwdGlvbiBmYWlsZWQuJywgNDA5KTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe2FhYWE6ZGVjcnlwdGVkUGFzc3dvcmR9KVxuICAgICAgICAgICAgICAgIHBhc3N3b3JkSGFzaCA9IGJjcnlwdC5oYXNoU3luYyhkZWNyeXB0ZWRQYXNzd29yZCk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBcbiAgICAgICAgICAgIGNvbnNvbGUubG9nKHtpc0NvbXBhbnlFeGlzdH0pXG4gICAgICAgICAgICBjb25zdCBhZG1pbiA9IGF3YWl0IGRiLkFkbWluLmNyZWF0ZSh7XG4gICAgICAgICAgICAgICAgZmlyc3ROYW1lOiBmaXJzdE5hbWUsIGxhc3ROYW1lOiBsYXN0TmFtZSwgZW1haWw6IFVzZXI/LmVtYWlsLCBwYXNzd29yZDogcGFzc3dvcmRIYXNoLCBpc0FjdGl2ZTogdHJ1ZSwgaXNWZXJpZnk6IHRydWUsXG4gICAgICAgICAgICAgICAgY29tcGFueUlkOiBpc0NvbXBhbnlFeGlzdC5faWQsIHZlcmZLZXk6IHJhbmRvbVN0cmluZygxMCksIHZlcmZLZXlFeHBpcnk6IG5ldyBEYXRlKCksIHRhY0lkZW50aXR5S2V5OiBVc2VyPy5JZGVudGl0eUtleVxuICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIFxuICAgICAgICAgICAgY29uc3Qgc2V0UGFja2FnZSA9IGF3YWl0IHBhY2thZ2VIZWxwZXIuc2V0UGFja2FnZURldGFpbHMoaXNDb21wYW55RXhpc3QsIHBhY2thZ2VEZXRhaWxzKVxuICAgICAgICB9XG5cbiAgICAgICAgYXdhaXQgZGIuQ29tcGFueS51cGRhdGVPbmUoe3RhY0xpY2Vuc2VLZXk6IGxpY2Vuc2VLZXl9LHtcbiAgICAgICAgICAgICRzZXQ6e1xuICAgICAgICAgICAgICAgIHBhY2thZ2VBY2Nlc3NLZXk6IHBhY2thZ2VEZXRhaWxzPy5wYWNrYWdlQWNjZXNzS2V5LFxuICAgICAgICAgICAgICAgIGFsaWFzOiBjb21wYW55Py5hbGlhc1xuICAgICAgICAgICAgfVxuICAgICAgICB9KVxuXG4gICAgICAgIGNvbnN0IGxpY2Vuc2VGb3JtYXQgPSB7XG4gICAgICAgICAgICBleHBpcmVkQXQ6IGVuZERhdGUsXG4gICAgICAgICAgICB1c2VyTGltaXQ6IGVtYWlsVXNlcnNDb3VudCxcbiAgICAgICAgICAgIHVzZXJMaW1pdE1lc3Nlbmdlcjogd2hhdHNhcHBVc2Vyc0NvdW50LFxuICAgICAgICAgICAgZG9tYWluTGltaXQ6IGRvbWFpbkNvdW50ICAgICAgICAgICAgXG4gICAgICAgIH1cblxuXG4gICAgICAgIGZvciAobGV0IGtleSBpbiBsaWNlbnNlRm9ybWF0KSB7XG4gICAgICAgICAgICBjb25zdCB1cGRhdGUgPSBhd2FpdCBkYi5NZXRhRGF0YS5maW5kT25lQW5kVXBkYXRlKHtcbiAgICAgICAgICAgICAgICBjb21wYW55SWQ6IGlzQ29tcGFueUV4aXN0Ll9pZCxcbiAgICAgICAgICAgICAgICBuYW1lOiBrZXksXG4gICAgICAgICAgICB9LHtcbiAgICAgICAgICAgICAgICB2YWx1ZTogbGljZW5zZUZvcm1hdFtrZXldXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgeyB1cHNlcnQ6IHRydWUsIG5ldzogdHJ1ZSwgc2V0RGVmYXVsdHNPbkluc2VydDogdHJ1ZSB9KVxuICAgICAgICAgICAgY29uc29sZS5sb2coe3VwZGF0ZSwga2V5fSlcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHNldFBhY2thZ2UgPSBhd2FpdCBwYWNrYWdlSGVscGVyLnNldFBhY2thZ2VEZXRhaWxzKGlzQ29tcGFueUV4aXN0LCBwYWNrYWdlRGV0YWlscylcblxuXG4gICAgICAgIHJldHVybiByZXMuc3RhdHVzKDIwMCkuanNvbih7XG4gICAgICAgICAgICBtZXNzYWdlczogXCJMaWNlbnNlIHVwZGF0ZWQgc3VjY2Vzc2Z1bGx5XCJcbiAgICAgICAgfSlcbiAgICB9Y2F0Y2goZXJyb3Ipe1xuICAgICAgICBjb25zdCBzdGF0dXNDb2RlID0gZXJyb3Iuc3RhdHVzIHx8IDUwMDtcbiAgICAgICAgY29uc3QgaXNDbGllbnRFcnJvciA9IHN0YXR1c0NvZGUgPj0gNDAwICYmIHN0YXR1c0NvZGUgPCA1MDA7XG4gICAgICAgIGNvbnNvbGUuZXJyb3IoJ0FQSSBFcnJvcjonLCBlcnJvcik7XG5cbiAgICAgICAgY29uc3QgcmVzcG9uc2VNZXNzYWdlID0gaXNDbGllbnRFcnJvclxuICAgICAgICAgICAgPyBlcnJvci5tZXNzYWdlIHx8ICdUaGUgcmVxdWVzdCBjb3VsZCBub3QgYmUgcHJvY2Vzc2VkLidcbiAgICAgICAgICAgIDogJ0FuIGludGVybmFsIHNlcnZlciBlcnJvciBvY2N1cnJlZC4nO1xuXG4gICAgICAgIHJlcy5zdGF0dXMoc3RhdHVzQ29kZSkuanNvbih7XG4gICAgICAgICAgICBzdWNjZXNzOiBmYWxzZSxcbiAgICAgICAgICAgIG1lc3NhZ2U6IHJlc3BvbnNlTWVzc2FnZSxcbiAgICAgICAgICAgIGVycm9yOiBpc0NsaWVudEVycm9yID8geyBjb2RlOiBlcnJvci5jb2RlIHx8ICdVTkVYUEVDVEVEX0VSUk9SJywgZGVzY3JpcHRpb246IGVycm9yLmRlc2NyaXB0aW9uIHx8IG51bGwgfSA6IHVuZGVmaW5lZCxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgIH1cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5wb3N0KGNvbnRyb2xsZXIpO1xuZXhwb3J0IGRlZmF1bHQgYXBpUm91dGVyOyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFHQSxJQUFJQSxVQUFVO0VBQUEseUZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUFBLFlBRXNFRixHQUFHLENBQUNHLElBQUksRUFBckdDLE9BQU8sYUFBUEEsT0FBTyxFQUFFQyxlQUFlLGFBQWZBLGVBQWUsRUFBRUMsa0JBQWtCLGFBQWxCQSxrQkFBa0IsRUFBRUMsV0FBVyxhQUFYQSxXQUFXLEVBQUVDLE9BQU8sYUFBUEEsT0FBTyxFQUFFQyxLQUFLLGFBQUxBLEtBQUssRUFBRUMsY0FBYyxhQUFkQSxjQUFjO1VBRTFGQyxVQUFVLDRCQUFFWCxHQUFHLGFBQUhBLEdBQUcsdUNBQUhBLEdBQUcsQ0FBRVksT0FBTywyRUFBWixhQUFjQyxhQUFhLDJEQUEzQix1QkFBNkJDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMseUVBQUksSUFBSTtVQUNwRUMsT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ0wsVUFBVSxFQUFWQTtVQUFVLENBQUMsQ0FBQztVQUFBO1VBQUEsT0FFRU0sRUFBRSxDQUFDQyxPQUFPLENBQUNDLE9BQU8sQ0FBQztZQUFDQyxhQUFhLEVBQUVULFVBQVU7WUFBRVUsU0FBUyxFQUFDO1VBQUksQ0FBQyxDQUFDO1FBQUE7VUFBdEZDLGNBQWM7VUFDbEJQLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQUNNLGNBQWMsRUFBZEE7VUFBYyxDQUFDLENBQUM7VUFBQSxJQUN6QkEsY0FBYztZQUFBO1lBQUE7VUFBQTtVQUFBLGtCQUN3QnRCLEdBQUcsQ0FBQ0csSUFBSSxDQUFDTSxLQUFLLEVBQTVDYyxTQUFTLG1CQUFUQSxTQUFTLEVBQUVDLFFBQVEsbUJBQVJBLFFBQVEsRUFBRUMsSUFBSSxtQkFBSkEsSUFBSTtVQUFBO1VBQUEsT0FFTlIsRUFBRSxDQUFDUyxLQUFLLENBQUNQLE9BQU8sQ0FBQztZQUFDUSxLQUFLLEVBQUVGLElBQUksYUFBSkEsSUFBSSx1QkFBSkEsSUFBSSxDQUFFRSxLQUFLO1lBQUVOLFNBQVMsRUFBRTtVQUFJLENBQUMsQ0FBQztRQUFBO1VBQTVFTyxZQUFZO1VBQUEsS0FDZkEsWUFBWTtZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FDTFgsRUFBRSxDQUFDUyxLQUFLLENBQUNHLFNBQVMsQ0FBQztZQUFDRixLQUFLLEVBQUVGLElBQUksYUFBSkEsSUFBSSx1QkFBSkEsSUFBSSxDQUFFRSxLQUFLO1lBQUVOLFNBQVMsRUFBRTtVQUFJLENBQUMsRUFBQztZQUFDUyxJQUFJLEVBQUM7Y0FBQ0MsY0FBYyxFQUFFTixJQUFJLGFBQUpBLElBQUksdUJBQUpBLElBQUksQ0FBRU87WUFBVztVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUEsTUFDcEcsSUFBSUMsWUFBWSxzQkFBZUwsWUFBWSxDQUFDRCxLQUFLLHNCQUFtQjtRQUFBO1VBQUE7VUFBQSxPQUd2RFYsRUFBRSxDQUFDQyxPQUFPLENBQUNnQixNQUFNLENBQUM7WUFDckNDLElBQUksRUFBRTNCLE9BQU8sQ0FBQzRCLFdBQVc7WUFBRWhCLGFBQWEsRUFBRVQsVUFBVTtZQUFFMEIsS0FBSyxFQUFFN0IsT0FBTyxhQUFQQSxPQUFPLHVCQUFQQSxPQUFPLENBQUU2QixLQUFLO1lBQzNFQyxZQUFZLEVBQUU5QixPQUFPLENBQUMrQixFQUFFO1lBQUVDLFlBQVksRUFBRSxJQUFJO1lBQUVDLFlBQVksRUFBRSxJQUFJO1lBQUVDLFFBQVEsRUFBRWxDLE9BQU8sYUFBUEEsT0FBTyx1QkFBUEEsT0FBTyxDQUFFa0MsUUFBUTtZQUFFQyxPQUFPLEVBQUVuQyxPQUFPLGFBQVBBLE9BQU8sdUJBQVBBLE9BQU8sQ0FBRW1DO1VBQ3JILENBQUMsQ0FBQztRQUFBO1VBSEZyQixjQUFjO1VBS1JzQixRQUFRLEdBQUc7WUFDYkMsT0FBTyxFQUFFLDRCQUE0QjtZQUNyQ0MsTUFBTSxFQUFFLE9BQU87WUFDZkMsUUFBUSxFQUFFO1VBQ2QsQ0FBQztVQUFBLDJDQUVlSCxRQUFRO1FBQUE7VUFBQTtZQUFBO1lBQUE7VUFBQTtVQUFmSSxHQUFHO1VBQUE7VUFBQSxPQUNhL0IsRUFBRSxDQUFDZ0MsUUFBUSxDQUFDQyxnQkFBZ0IsQ0FBQztZQUM5Q0MsU0FBUyxFQUFFN0IsY0FBYyxDQUFDOEIsR0FBRztZQUM3QmpCLElBQUksRUFBRWE7VUFDVixDQUFDLEVBQUM7WUFDRUssS0FBSyxFQUFFVCxRQUFRLENBQUNJLEdBQUc7VUFDdkIsQ0FBQyxFQUNEO1lBQUVNLE1BQU0sRUFBRSxJQUFJO1lBQUUsT0FBSyxJQUFJO1lBQUVDLG1CQUFtQixFQUFFO1VBQUssQ0FBQyxDQUFDO1FBQUE7VUFOakRDLE1BQU07VUFPWnpDLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQUN3QyxNQUFNLEVBQU5BLE1BQU07WUFBRVIsR0FBRyxFQUFIQTtVQUFHLENBQUMsQ0FBQztVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUEsT0FHeEIvQixFQUFFLENBQUN3QyxLQUFLLENBQUN2QixNQUFNLENBQUM7WUFDbEJ3QixTQUFTLEVBQUUsZ0JBQWdCO1lBQzNCQyxJQUFJLEVBQUMsUUFBUTtZQUNiQyxjQUFjLEVBQUUsSUFBSTtZQUNwQkMsV0FBVyxFQUFFLEtBQUs7WUFDbEJDLGVBQWUsRUFBRSxLQUFLO1lBQ3RCWCxTQUFTLEVBQUU3QixjQUFjLENBQUM4QixHQUFHO1lBQzdCVyxTQUFTLEVBQUUsSUFBSUMsSUFBSSxDQUFDLFlBQVk7VUFDcEMsQ0FBQyxDQUFDO1FBQUE7VUFBQSxNQUdFdkMsSUFBSSxhQUFKQSxJQUFJLGVBQUpBLElBQUksQ0FBRXdDLElBQUk7WUFBQTtZQUFBO1VBQUE7VUFDSkMsaUJBQWlCLEdBQUdDLGtCQUFNLENBQUNDLE9BQU8sQ0FBQzNDLElBQUksQ0FBQ3dDLElBQUksRUFBRUksa0JBQU0sQ0FBQ0MsWUFBWSxDQUFDQyxhQUFhLENBQUM7VUFBQSxJQUNqRkwsaUJBQWlCO1lBQUE7WUFBQTtVQUFBO1VBQUEsTUFDWixJQUFJakMsWUFBWSxDQUFDLHNEQUFzRCxFQUFFLEdBQUcsQ0FBQztRQUFBO1VBRXZGbEIsT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ3dELElBQUksRUFBQ047VUFBaUIsQ0FBQyxDQUFDO1VBQ3JDTyxZQUFZLEdBQUdDLG9CQUFNLENBQUNDLFFBQVEsQ0FBQ1QsaUJBQWlCLENBQUM7UUFBQztVQUd0RG5ELE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQUNNLGNBQWMsRUFBZEE7VUFBYyxDQUFDLENBQUM7VUFBQTtVQUFBLE9BQ1RMLEVBQUUsQ0FBQ1MsS0FBSyxDQUFDUSxNQUFNLENBQUM7WUFDaENYLFNBQVMsRUFBRUEsU0FBUztZQUFFQyxRQUFRLEVBQUVBLFFBQVE7WUFBRUcsS0FBSyxFQUFFRixJQUFJLGFBQUpBLElBQUksdUJBQUpBLElBQUksQ0FBRUUsS0FBSztZQUFFaUQsUUFBUSxFQUFFSCxZQUFZO1lBQUVJLFFBQVEsRUFBRSxJQUFJO1lBQUVDLFFBQVEsRUFBRSxJQUFJO1lBQ3BIM0IsU0FBUyxFQUFFN0IsY0FBYyxDQUFDOEIsR0FBRztZQUFFMkIsT0FBTyxFQUFFLElBQUFDLHVCQUFZLEVBQUMsRUFBRSxDQUFDO1lBQUVDLGFBQWEsRUFBRSxJQUFJakIsSUFBSSxFQUFFO1lBQUVqQyxjQUFjLEVBQUVOLElBQUksYUFBSkEsSUFBSSx1QkFBSkEsSUFBSSxDQUFFTztVQUMvRyxDQUFDLENBQUM7UUFBQTtVQUhJa0QsS0FBSztVQUFBO1VBQUEsT0FLY0MseUJBQWEsQ0FBQ0MsaUJBQWlCLENBQUM5RCxjQUFjLEVBQUVaLGNBQWMsQ0FBQztRQUFBO1VBQWxGMkUsV0FBVTtRQUFBO1VBQUE7VUFBQSxPQUdkcEUsRUFBRSxDQUFDQyxPQUFPLENBQUNXLFNBQVMsQ0FBQztZQUFDVCxhQUFhLEVBQUVUO1VBQVUsQ0FBQyxFQUFDO1lBQ25EbUIsSUFBSSxFQUFDO2NBQ0R3RCxnQkFBZ0IsRUFBRTVFLGNBQWMsYUFBZEEsY0FBYyx1QkFBZEEsY0FBYyxDQUFFNEUsZ0JBQWdCO2NBQ2xEakQsS0FBSyxFQUFFN0IsT0FBTyxhQUFQQSxPQUFPLHVCQUFQQSxPQUFPLENBQUU2QjtZQUNwQjtVQUNKLENBQUMsQ0FBQztRQUFBO1VBRUlrRCxhQUFhLEdBQUc7WUFDbEJDLFNBQVMsRUFBRXBGLE9BQU87WUFDbEJxRixTQUFTLEVBQUVwRixlQUFlO1lBQzFCcUYsa0JBQWtCLEVBQUVwRixrQkFBa0I7WUFDdENxRixXQUFXLEVBQUVwRjtVQUNqQixDQUFDO1VBQUEsMkNBR2VnRixhQUFhO1FBQUE7VUFBQTtZQUFBO1lBQUE7VUFBQTtVQUFwQnZDLElBQUc7VUFBQTtVQUFBLE9BQ2EvQixFQUFFLENBQUNnQyxRQUFRLENBQUNDLGdCQUFnQixDQUFDO1lBQzlDQyxTQUFTLEVBQUU3QixjQUFjLENBQUM4QixHQUFHO1lBQzdCakIsSUFBSSxFQUFFYTtVQUNWLENBQUMsRUFBQztZQUNFSyxLQUFLLEVBQUVrQyxhQUFhLENBQUN2QyxJQUFHO1VBQzVCLENBQUMsRUFDRDtZQUFFTSxNQUFNLEVBQUUsSUFBSTtZQUFFLE9BQUssSUFBSTtZQUFFQyxtQkFBbUIsRUFBRTtVQUFLLENBQUMsQ0FBQztRQUFBO1VBTmpEQyxPQUFNO1VBT1p6QyxPQUFPLENBQUNDLEdBQUcsQ0FBQztZQUFDd0MsTUFBTSxFQUFOQSxPQUFNO1lBQUVSLEdBQUcsRUFBSEE7VUFBRyxDQUFDLENBQUM7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBLE9BR0xtQyx5QkFBYSxDQUFDQyxpQkFBaUIsQ0FBQzlELGNBQWMsRUFBRVosY0FBYyxDQUFDO1FBQUE7VUFBbEYyRSxVQUFVO1VBQUEsaUNBR1RwRixHQUFHLENBQUMyRixNQUFNLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQztZQUN4QkMsUUFBUSxFQUFFO1VBQ2QsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBO1VBRUlDLFVBQVUsR0FBRyxZQUFNSCxNQUFNLElBQUksR0FBRztVQUNoQ0ksYUFBYSxHQUFHRCxVQUFVLElBQUksR0FBRyxJQUFJQSxVQUFVLEdBQUcsR0FBRztVQUMzRGhGLE9BQU8sQ0FBQ2tGLEtBQUssQ0FBQyxZQUFZLGNBQVE7VUFFNUJDLGVBQWUsR0FBR0YsYUFBYSxHQUMvQixZQUFNRyxPQUFPLElBQUkscUNBQXFDLEdBQ3RELG9DQUFvQztVQUUxQ2xHLEdBQUcsQ0FBQzJGLE1BQU0sQ0FBQ0csVUFBVSxDQUFDLENBQUNGLElBQUksQ0FBQztZQUN4Qk8sT0FBTyxFQUFFLEtBQUs7WUFDZEQsT0FBTyxFQUFFRCxlQUFlO1lBQ3hCRCxLQUFLLEVBQUVELGFBQWEsR0FBRztjQUFFSyxJQUFJLEVBQUUsWUFBTUEsSUFBSSxJQUFJLGtCQUFrQjtjQUFFQyxXQUFXLEVBQUUsWUFBTUEsV0FBVyxJQUFJO1lBQUssQ0FBQyxHQUFHQztVQUNoSCxDQUFDLENBQUM7UUFBQztRQUFBO1VBQUE7TUFBQTtJQUFBO0VBQUEsQ0FFTjtFQUFBLGdCQXBIRHhHLFVBQVU7SUFBQTtFQUFBO0FBQUEsR0FvSFQ7QUFDTCxJQUFNeUcsU0FBUyxHQUFHQyxtQkFBTyxDQUFDQyxNQUFNLEVBQUU7QUFDbENGLFNBQVMsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUM3RyxVQUFVLENBQUM7QUFBQyxlQUN2QnlHLFNBQVM7QUFBQSJ9