"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _packageHelper = _interopRequireDefault(require("../../service/package-helper"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var packageDetails, company, syncPackage, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          packageDetails = req.body.packageDetails;
          _context.next = 4;
          return db.Company.findOne({
            packageAccessKey: packageDetails.packageAccessKey,
            deletedAt: null
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Company not found!', 404);
        case 7:
          _context.next = 9;
          return _packageHelper["default"].setPackageDetails(company, packageDetails);
        case 9:
          syncPackage = _context.sent;
          _context.next = 12;
          return db.Company.updateOne({
            _id: company._id
          }, {
            $set: {
              packageModifiedLocally: true
            }
          });
        case 12:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Package updated successfully"
          }));
        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 22:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 15]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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